/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import java.io.File;

public class UtilFile {
    public static String DIRECTORY_SEPARATOR = File.separator;
    public static final String ZIP_EXTENSION = ".gz";

    private static String getCorrectSeparators(String pathOrFilename) {
        return pathOrFilename.replace("\\", DIRECTORY_SEPARATOR).replace("//", DIRECTORY_SEPARATOR).replace("/", DIRECTORY_SEPARATOR);
    }

    private static String removeMultipleSeparators(String pathOrFilename) {
        String doubleSeparator = String.valueOf(DIRECTORY_SEPARATOR) + DIRECTORY_SEPARATOR;
        if (pathOrFilename.indexOf(doubleSeparator) >= 0) {
            pathOrFilename = pathOrFilename.replace(doubleSeparator, DIRECTORY_SEPARATOR);
        }
        return pathOrFilename;
    }

    public static String getCorrectPath(String path) throws IllegalArgumentException {
        if (path == null) {
            return "";
        }
        path = UtilFile.getCorrectSeparators(path);
        if (!(path = UtilFile.removeMultipleSeparators(path)).endsWith(DIRECTORY_SEPARATOR)) {
            path = String.valueOf(path) + DIRECTORY_SEPARATOR;
        }
        return path;
    }

    public static String getFilename(String filenamePath) {
        String correctFilenamePath = UtilFile.getCorrectSeparators(filenamePath);
        if (correctFilenamePath.indexOf(DIRECTORY_SEPARATOR) < 0) {
            return filenamePath;
        }
        return correctFilenamePath.substring(correctFilenamePath.lastIndexOf(DIRECTORY_SEPARATOR) + 1, correctFilenamePath.length());
    }

    public static String getFilepath(String filenamePath) {
        String correctFilenamePath = UtilFile.getCorrectSeparators(filenamePath);
        if (correctFilenamePath.indexOf(DIRECTORY_SEPARATOR) < 0) {
            return "";
        }
        return correctFilenamePath.substring(0, correctFilenamePath.lastIndexOf(DIRECTORY_SEPARATOR));
    }
}

