/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IDataAccess;
import ch.elexis.core.data.interfaces.events.MessageEvent;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class ScriptUtil {
    public static Object loadDataFromPlugin(String connector) {
        String[] adr = connector.split(":");
        if (adr.length < 4) {
            MessageEvent.fireError("Datenzugriff-Fehler", "Das Datenfeld " + connector + " wird falsch angesprochen");
            return null;
        }
        String plugin = adr[0];
        String dependendObject = adr[1];
        String dates = adr[2];
        String desc = adr[3];
        String[] params = null;
        if (adr.length == 5) {
            params = adr[4].split("\\.");
        }
        PersistentObject ref = null;
        if (dependendObject.equals("Patient")) {
            ref = ElexisEventDispatcher.getSelectedPatient();
        } else if (dependendObject.equals("Konsultation")) {
            ref = Konsultation.getAktuelleKons();
        }
        for (IConfigurationElement ic : Extensions.getExtensions("ch.elexis.core.data.DataAccess", "DataAccess")) {
            String icName = ic.getAttribute("name");
            if (!icName.equals(plugin)) continue;
            try {
                IDataAccess ida = (IDataAccess)ic.createExecutableExtension("class");
                Result<Object> ret = ida.getObject(desc, ref, dates, params);
                if (ret.isOK()) {
                    return ret.get();
                }
                ResultAdapter.displayResult(ret, "Fehler beim  Einsetzen von Feldern");
            }
            catch (CoreException e) {
                ExHandler.handle((Throwable)e);
            }
        }
        return null;
    }
}

