/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import ch.rgw.tools.ExHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessController {
    private String proc_result;
    private String proc_err;
    private int proc_exitCode;
    private static Logger log = LoggerFactory.getLogger((String)ProcessController.class.getName());

    public String getResult() {
        return this.proc_result;
    }

    public String getErrorString() {
        return this.proc_err;
    }

    public int getExitCode() {
        return this.proc_exitCode;
    }

    public boolean run(String program, String command, String inputStr) {
        Process p;
        log.info("executing " + program + " " + command + ", " + inputStr);
        try {
            p = Runtime.getRuntime().exec(new String[]{program, command});
        }
        catch (IOException io) {
            ExHandler.handle((Throwable)io);
            return false;
        }
        if (inputStr != null) {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
            try {
                out.write(inputStr);
                out.close();
            }
            catch (IOException io) {
                System.out.println("Exception at write! " + io.getMessage());
                return false;
            }
        }
        ProcessStreamReader psr_stdout = new ProcessStreamReader(p.getInputStream(), "ERROR");
        ProcessStreamReader psr_stderr = new ProcessStreamReader(p.getErrorStream(), "OUTPUT");
        psr_stdout.start();
        psr_stderr.start();
        try {
            psr_stdout.join();
            psr_stderr.join();
        }
        catch (InterruptedException i) {
            System.out.println("Exception at join! " + i.getMessage());
            return false;
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException i) {
            System.out.println("Exception at waitfor! " + i.getMessage());
            return false;
        }
        try {
            this.proc_exitCode = p.exitValue();
        }
        catch (IllegalThreadStateException itse) {
            return false;
        }
        this.proc_result = psr_stdout.getString();
        this.proc_err = psr_stderr.getString();
        return true;
    }

    class ProcessStreamReader
    extends Thread {
        InputStream is;
        String type;
        OutputStream os;
        String fullLine = "";

        ProcessStreamReader(InputStream is, String type) {
            this(is, type, null);
        }

        ProcessStreamReader(InputStream is, String type, OutputStream redirect) {
            this.is = is;
            this.type = type;
            this.os = redirect;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.fullLine = String.valueOf(this.fullLine) + line + "\n";
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        String getString() {
            return this.fullLine;
        }
    }
}

