/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.service;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IStoreToStringService;
import ch.elexis.data.PersistentObject;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class StoreToStringServiceHolder {
    private static IStoreToStringService storeToStringService;

    @Reference
    public void setStoreToStringService(IStoreToStringService modelService) {
        storeToStringService = modelService;
    }

    public static IStoreToStringService get() {
        if (storeToStringService == null) {
            throw new IllegalStateException("No IModelService available");
        }
        return storeToStringService;
    }

    public static String getStoreToString(Object object) {
        if (object instanceof PersistentObject) {
            return ((PersistentObject)object).storeToString();
        }
        if (object instanceof Identifiable) {
            return (String)StoreToStringServiceHolder.get().storeToString((Identifiable)object).orElseThrow(() -> new IllegalStateException("No storeToString for [" + object + "]"));
        }
        throw new IllegalStateException("No storeToString for [" + object + "]");
    }

    public static Object getLoadFromString(String storeToString) {
        Optional loaded = StoreToStringServiceHolder.get().loadFromString(storeToString);
        if (!loaded.isPresent()) {
            return CoreHub.poFactory.createFromString(storeToString);
        }
        return loaded.get();
    }
}

