/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.interfaces.events;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageEvent {
    private static Logger logger = LoggerFactory.getLogger(MessageEvent.class);
    public final String title;
    public final String message;
    public final MessageType mt;
    public final IStatus status;

    public MessageEvent(MessageType mt, String title, String message) {
        this(mt, title, message, null);
    }

    public MessageEvent(MessageType mt, String title, String message, IStatus status) {
        this.title = title;
        this.message = message;
        this.mt = mt;
        this.status = status;
    }

    public void fire() {
        ElexisEventDispatcher.getInstance().fireMessageEvent(this);
    }

    public static void fireError(String title, String message) {
        MessageEvent.fire(MessageType.ERROR, title, message, null, null, false);
    }

    public static void fireError(String title, String message, Exception ex) {
        MessageEvent.fire(MessageType.ERROR, title, message, null, ex, false);
    }

    public static void fireLoggedError(String title, String message) {
        MessageEvent.fire(MessageType.ERROR, title, message, null, null, true);
    }

    public static void fireLoggedError(String title, String message, Exception ex) {
        MessageEvent.fire(MessageType.ERROR, title, message, null, ex, true);
    }

    public static void fireInformation(String title, String message) {
        MessageEvent.fire(MessageType.INFO, title, message, null, null, true);
    }

    private static void fire(MessageType mt, String title, String message, IStatus status, Exception ex, boolean log) {
        if (log) {
            String logMsg = String.valueOf(title) + " - " + message;
            switch (mt) {
                case ERROR: {
                    if (ex == null) {
                        logger.error(logMsg);
                        break;
                    }
                    logger.error(logMsg, (Throwable)ex);
                    break;
                }
                case WARN: {
                    if (ex == null) {
                        logger.warn(logMsg);
                        break;
                    }
                    logger.warn(logMsg, (Throwable)ex);
                    break;
                }
                case INFO: {
                    if (ex == null) {
                        logger.info(logMsg);
                        break;
                    }
                    logger.info(logMsg, (Throwable)ex);
                }
            }
        }
        new MessageEvent(mt, title, message, status).fire();
    }

    public static enum MessageType {
        INFO,
        WARN,
        ERROR;

    }
}

