/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.dbupdate;

import ch.elexis.core.data.extension.CoreOperationAdvisorHolder;
import ch.elexis.core.data.extension.ICoreOperationAdvisor;
import ch.elexis.core.data.util.IRunnableWithProgress;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.data.BillingSystem;
import ch.elexis.data.Fall;
import ch.elexis.data.Query;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallUpdatesFor36 {
    protected static Logger log = LoggerFactory.getLogger(FallUpdatesFor36.class);

    public static void transferLawAndCostBearerTo36Model() {
        final String CONFIG_KEY = "FallGesetzCostBearerMigratedTo36";
        String value = ConfigServiceHolder.getGlobal((String)CONFIG_KEY, null);
        if (value == null) {
            ConfigServiceHolder.setGlobal((String)CONFIG_KEY, (String)"-1");
            IRunnableWithProgress irwp = new IRunnableWithProgress(){
                private StringBuilder errors = new StringBuilder();

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Aktualisiere Abrechnungssystem-Konfiguration", 2);
                    log.info("Starting FallUpdatesFor36#transferLawAndCostBearerTo36Model");
                    FallUpdatesFor36.moveFallExtInfoBillingToFallBillingSystem((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                    SubMonitor monitor2 = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                    String[] abrechnungsSysteme = BillingSystem.getAbrechnungsSysteme();
                    monitor2.beginTask("Aktualisiere Gesetz und Kostentr\u00e4ger", abrechnungsSysteme.length);
                    String[] stringArray = abrechnungsSysteme;
                    int n = abrechnungsSysteme.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String abrechnungssystem = stringArray[n2];
                        monitor2.subTask("Aktualisiere Gesetz und Kostentr\u00e4ger f\u00fcr Abrechnungssystem [" + abrechnungssystem + "]");
                        String abrechnungsSystemGesetz = BillingSystem.getBillingSystemConstant(abrechnungssystem, "gesetz");
                        if (StringUtils.isNotEmpty((CharSequence)abrechnungsSystemGesetz)) {
                            try {
                                BillingLaw billingLaw = BillingLaw.valueOf((String)abrechnungsSystemGesetz.toUpperCase());
                                BillingSystem.setConfigurationValue(abrechnungssystem, "defaultBillingLaw", billingLaw.name());
                                BillingSystem.removeExtInfoValueForAllFaelleOfBillingSystem(abrechnungsSystemGesetz, Arrays.asList("gesetz", "Gesetz"));
                                BillingSystem.removeBillingSystemConstant(abrechnungssystem, "gesetz=" + abrechnungsSystemGesetz);
                                BillingSystem.removeBillingSystemConstant(abrechnungssystem, "Gesetz=" + abrechnungsSystemGesetz);
                            }
                            catch (IllegalArgumentException iae) {
                                log.error("Could not resolve law [{}] from billing systeem [{}]", (Object)abrechnungsSystemGesetz, (Object)abrechnungssystem);
                                this.errors.append("Fehler Gesetz-Konfiguration f\u00fcr " + abrechnungssystem + "\n");
                            }
                        } else {
                            log.error("No gesetz constant found for billing system [{}]", (Object)abrechnungssystem);
                        }
                        String requirements = BillingSystem.getRequirements(abrechnungssystem);
                        if (requirements != null && requirements.contains("Kostentr\u00e4ger:K")) {
                            BillingSystem.moveCostBearerFromExtinfoToDBRow(abrechnungssystem, "Kostentr\u00e4ger");
                            requirements = requirements.replace("Kostentr\u00e4ger:K:;", "");
                            requirements = requirements.replace("Kostentr\u00e4ger:K:", "");
                            requirements = requirements.replace("Kostentr\u00e4ger:K;", "");
                            requirements = requirements.replace("Kostentr\u00e4ger:K", "");
                            ConfigServiceHolder.setGlobal((String)("billing/systems/" + abrechnungssystem + "/bedingungen"), (String)requirements);
                        } else {
                            log.error("Could not find cost bearer entry for billing system [{}]", (Object)abrechnungssystem);
                            this.errors.append("Kein Kostentr\u00e4ger-Konfiguration f\u00fcr [" + abrechnungssystem + "] gefunden\n");
                        }
                        monitor2.worked(1);
                        ++n2;
                    }
                    ConfigServiceHolder.setGlobal((String)CONFIG_KEY, (String)"1");
                    monitor.done();
                    String errorString = this.errors.toString();
                    StringBuilder message = new StringBuilder();
                    if (StringUtils.isNotBlank((CharSequence)errorString)) {
                        message.append("Bei der automatisierten Aktualisierung der Abrechnungssysteme sind folgende Fehler aufgetreten:\n\n");
                        message.append(String.valueOf(errorString.toString()) + "\n\n");
                    } else {
                        message.append("Die automatisierte \u00dcbernahme wurde ohne Probleme abgeschlossen.");
                    }
                    message.append("Bitte deaktivieren Sie, falls notwendig, manuell die Kostentr\u00e4ger-Auswahl.\nSiehe https://wiki.elexis.info/Ab4cf3");
                    CoreOperationAdvisorHolder.get().openInformation("Aktualisierung Abrechnungssystem - Automatische \u00dcbernahme", message.toString());
                }
            };
            ICoreOperationAdvisor cod = CoreOperationAdvisorHolder.get();
            cod.showProgress(irwp, "Abrechnungssystem-Konfiguration aktualisieren");
        }
    }

    public static String moveFallExtInfoBillingToFallBillingSystem(IProgressMonitor pm) {
        StringBuilder sb = new StringBuilder();
        Query query = new Query(Fall.class);
        query.clear(true);
        List allFaelle = query.execute();
        pm.beginTask("Moving Fall#ExtInfo#billing values...", allFaelle.size());
        for (Fall fall : allFaelle) {
            String billingSystem = (String)fall.getExtInfoStoredObjectByKey("billing");
            if (billingSystem != null) {
                fall.set("Gesetz", billingSystem);
                fall.setExtInfoStoredObjectByKey("billing", null);
                sb.append("[" + fall.getId() + "] Moving Fall#ExtInfo#Billing [" + billingSystem + "] to table\n");
            }
            pm.worked(1);
        }
        pm.done();
        return sb.toString();
    }
}

