/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.preferences.UserCasePreferences;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.data.BillingSystem;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

class RnControlFieldProvider
implements ViewerConfigurer.ControlFieldProvider {
    static final String[] stats = new String[]{Messages.RnControlFieldProvider_all, Messages.RnControlFieldProvider_open, Messages.RnControlFieldProvider_openAndPrinted, Messages.RnControlFieldProvider_partlyPaid, Messages.RnControlFieldProvider_paid, Messages.RnControlFieldProvider_overpaid, Messages.RnControlFieldProvider_reminder, Messages.RnControlFieldProvider_reminderPrinted, Messages.RnControlFieldProvider_reminder2, Messages.RnControlFieldProvider_reminder2Printed, Messages.RnControlFieldProvider_reminder3, Messages.RnControlFieldProvider_reminder3Printed, Messages.RnControlFieldProvider_enforcement, Messages.RnControlFieldProvider_partlyLost, Messages.RnControlFieldProvider_totallyLost, Messages.RnControlFieldProvider_storno, Messages.RnControlFieldProvider_erroneous, Messages.RnControlFieldProvider_toPrint, Messages.RnControlFieldProvider_toBePaid, Messages.RnControlFieldProvider_dontRemind, Messages.RnControlFieldProvider_writtenOff, Messages.RnControlFieldProvider_rejected};
    static final int[] statInts;
    static final int STAT_DEFAULT_INDEX = 1;
    private static final String ALLE;
    private static final String ALL;
    Combo cbStat;
    Combo cbZType;
    private List<ViewerConfigurer.ControlFieldListener> listeners;
    private final SelectionAdapter csel = new CtlSelectionListener();
    private boolean bDateAsStatus;
    private HyperlinkAdapter hlPatient;
    private Label lPatient;
    Text tNr;
    Text tBetrag;
    String oldSelectedBillingSystem = "";
    Patient actPatient;

    static {
        int[] nArray = new int[22];
        nArray[1] = 4;
        nArray[2] = 5;
        nArray[3] = 15;
        nArray[4] = 16;
        nArray[5] = 17;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 18;
        nArray[16] = 22;
        nArray[17] = 23;
        nArray[18] = 24;
        nArray[19] = 25;
        nArray[20] = 26;
        nArray[21] = 27;
        statInts = nArray;
        ALLE = Messages.RnControlFieldProvider_allPatients;
        ALL = Messages.RnControlFieldProvider_all;
    }

    RnControlFieldProvider() {
    }

    @Override
    public Composite createControl(final Composite parent) {
        Composite ret = new Composite(parent, 0);
        this.listeners = new ArrayList<ViewerConfigurer.ControlFieldListener>();
        ret.setLayout((Layout)new GridLayout(5, true));
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.hlPatient = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Patient oldPatient = RnControlFieldProvider.this.actPatient;
                KontaktSelektor ksl = new KontaktSelektor(parent.getShell(), Patient.class, Messages.RnControlFieldProvider_selectPatientCaption, Messages.RnControlFieldProvider_selectPatientMessage, true, new String[0]);
                if (ksl.open() == 0) {
                    RnControlFieldProvider.this.actPatient = (Patient)ksl.getSelection();
                    if (RnControlFieldProvider.this.actPatient != null) {
                        RnControlFieldProvider.this.lPatient.setText(RnControlFieldProvider.this.actPatient.getLabel());
                        RnControlFieldProvider.this.cbStat.setText(stats[0]);
                    } else {
                        RnControlFieldProvider.this.lPatient.setText(ALLE);
                        RnControlFieldProvider.this.cbStat.setText(stats[1]);
                    }
                } else {
                    RnControlFieldProvider.this.actPatient = null;
                    RnControlFieldProvider.this.lPatient.setText(ALLE);
                    RnControlFieldProvider.this.cbStat.setText(stats[1]);
                }
                if (RnControlFieldProvider.this.actPatient == null && oldPatient == null) {
                    return;
                }
                if (RnControlFieldProvider.this.actPatient != null && oldPatient != null && RnControlFieldProvider.this.actPatient.equals((Object)oldPatient)) {
                    return;
                }
                RnControlFieldProvider.this.fireChangedEvent();
            }
        };
        new Label(ret, 0).setText(Messages.RnControlFieldProvider_state);
        Label lbl = SWTHelper.createHyperlink(ret, Messages.RnControlFieldProvider_patient2, (IHyperlinkListener)this.hlPatient);
        lbl.setForeground(UiDesk.getColorRegistry().get("blau"));
        new Label(ret, 0).setText(Messages.RnControlFieldProvider_PaymentSystem);
        new Label(ret, 0).setText(Messages.RnControlFieldProvider_invoideNr);
        new Label(ret, 0).setText(Messages.RnControlFieldProvider_amount);
        this.cbStat = new Combo(ret, 8);
        this.cbStat.setVisibleItemCount(stats.length);
        this.cbStat.setItems(stats);
        this.cbStat.addSelectionListener((SelectionListener)this.csel);
        this.cbStat.select(1);
        this.lPatient = new Label(ret, 0);
        this.lPatient.setText(ALLE);
        this.cbZType = new Combo(ret, 12);
        this.cbZType.setItems(UserCasePreferences.sortBillingSystems(BillingSystem.getAbrechnungsSysteme()));
        this.cbZType.add(ALL);
        this.cbZType.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                Object[] newItems;
                Object[] currItems = RnControlFieldProvider.this.cbZType.getItems();
                if (!Arrays.equals(currItems, newItems = UserCasePreferences.sortBillingSystems(BillingSystem.getAbrechnungsSysteme()))) {
                    String savedItem = RnControlFieldProvider.this.cbZType.getText();
                    RnControlFieldProvider.this.cbZType.setItems((String[])newItems);
                    RnControlFieldProvider.this.cbZType.setText(savedItem);
                    RnControlFieldProvider.this.cbZType.add(ALL);
                }
                RnControlFieldProvider.this.oldSelectedBillingSystem = RnControlFieldProvider.this.cbZType.getText();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.cbZType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int separatorPos = UserCasePreferences.getBillingSystemsMenuSeparatorPos(BillingSystem.getAbrechnungsSysteme());
                if (RnControlFieldProvider.this.cbZType.getSelectionIndex() == separatorPos) {
                    RnControlFieldProvider.this.cbZType.select(RnControlFieldProvider.this.cbZType.indexOf(RnControlFieldProvider.this.oldSelectedBillingSystem));
                } else {
                    RnControlFieldProvider.this.oldSelectedBillingSystem = RnControlFieldProvider.this.cbZType.getText();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tNr = new Text(ret, 2048);
        this.tNr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (RnControlFieldProvider.this.tNr.getText().length() == 0) {
                    RnControlFieldProvider.this.cbStat.select(1);
                }
                RnControlFieldProvider.this.fireChangedEvent();
            }
        });
        this.tBetrag = new Text(ret, 2048);
        this.tBetrag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (RnControlFieldProvider.this.tNr.getText().length() == 0) {
                    RnControlFieldProvider.this.cbStat.select(1);
                }
                RnControlFieldProvider.this.fireChangedEvent();
            }
        });
        GridData sgd = new GridData();
        sgd.minimumWidth = 100;
        sgd.widthHint = 100;
        return ret;
    }

    @Override
    public void addChangeListener(ViewerConfigurer.ControlFieldListener cl) {
        this.listeners.add(cl);
    }

    @Override
    public void removeChangeListener(ViewerConfigurer.ControlFieldListener cl) {
        this.listeners.remove(cl);
    }

    public boolean getDateModeIsStatus() {
        return this.bDateAsStatus;
    }

    @Override
    public String[] getValues() {
        String[] ret = new String[5];
        int selIdx = this.cbStat.getSelectionIndex();
        ret[0] = selIdx != -1 ? Integer.toString(statInts[selIdx]) : "1";
        if (this.actPatient != null) {
            ret[1] = this.actPatient.getId();
        }
        ret[2] = this.tNr.getText();
        ret[3] = this.tBetrag.getText().replaceAll("\\.", "");
        if (StringTool.isNothing((Object)ret[2])) {
            ret[2] = null;
        } else {
            this.clearValues();
            this.tNr.setText(ret[2]);
            ret[0] = "0";
            ret[1] = null;
            ret[3] = null;
        }
        if (StringTool.isNothing((Object)ret[3])) {
            ret[3] = null;
        } else {
            this.clearValues();
            this.tBetrag.setText(ret[3]);
            ret[0] = "0";
            ret[1] = null;
            ret[2] = null;
        }
        ret[4] = this.cbZType.getText();
        if (StringTool.isNothing((Object)ret[4]) || ret[4].equals(ALL)) {
            ret[4] = null;
        }
        return ret;
    }

    @Override
    public void clearValues() {
        this.cbStat.select(0);
        this.tNr.setText("");
        this.actPatient = null;
        this.lPatient.setText(ALLE);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public void setQuery(Query q) {
    }

    @Override
    public void setQuery(IQuery<?> query) {
    }

    @Override
    public IFilter createFilter() {
        return new IFilter(){

            public boolean select(Object element) {
                return true;
            }
        };
    }

    @Override
    public void fireChangedEvent() {
        UiDesk.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> hm = new HashMap<String, String>();
                hm.put(Messages.RnControlFieldProvider_state, "0");
                for (ViewerConfigurer.ControlFieldListener lis : RnControlFieldProvider.this.listeners) {
                    lis.changed(hm);
                }
            }
        });
    }

    @Override
    public void fireSortEvent(String text) {
        for (ViewerConfigurer.ControlFieldListener lis : this.listeners) {
            lis.reorder(text);
        }
    }

    @Override
    public void setFocus() {
    }

    private static class CtlSelectionListener
    extends SelectionAdapter {
        private CtlSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
        }
    }
}

