/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.codesystems;

import ch.elexis.core.ui.util.CoreUiUtil;
import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.slf4j.LoggerFactory;

public class ContributionAction
extends Action {
    private String commandId;
    private String label;
    private Object[] selection;

    public ContributionAction(IConfigurationElement command) {
        this.commandId = command.getAttribute("commandId");
        this.label = command.getAttribute("label");
    }

    public void setSelection(Object[] selection) {
        this.selection = selection;
        if (selection != null) {
            CoreUiUtil.setCommandSelection(this.commandId, selection);
        }
    }

    public void run() {
        this.executeCommand();
    }

    public Object executeCommand() {
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command cmd = commandService.getCommand(this.commandId);
            ExecutionEvent ee = new ExecutionEvent(cmd, Collections.EMPTY_MAP, null, null);
            return cmd.executeWithChecks(ee);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("cannot execute command with id: " + this.commandId, (Throwable)e);
            return null;
        }
    }

    public String getText() {
        return this.label;
    }

    public boolean isValid() {
        return this.commandId != null && !this.commandId.isEmpty() && this.label != null && !this.label.isEmpty();
    }

    public boolean isVisible() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command cmd = commandService.getCommand(this.commandId);
        IHandler handler = cmd.getHandler();
        if (handler != null) {
            return handler.isEnabled();
        }
        return true;
    }
}

