/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.codesystems;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.interfaces.ICodeElement;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.DelegatingSelectionProvider;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.FavoritenCTabItem;
import ch.elexis.core.ui.views.IDetailDisplay;
import ch.elexis.core.ui.views.codesystems.CodeElementStatisticsComposite;
import ch.elexis.core.ui.views.codesystems.CodeSystemDescription;
import ch.elexis.core.ui.views.codesystems.ContributionAction;
import ch.elexis.core.ui.views.codesystems.Messages;
import ch.elexis.data.Anwender;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CodeSelectorFactory
implements IExecutableExtension {
    private static final String CAPTION_ERROR = Messages.CodeSelectorFactory_error;
    public static int ITEMS_TO_SHOW_IN_MFU_LIST = 15;
    private static Logger log = LoggerFactory.getLogger(CodeSelectorFactory.class);

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public abstract ViewerConfigurer createViewerConfigurer(CommonViewer var1);

    public abstract Class<?> getElementClass();

    public abstract void dispose();

    public abstract String getCodeSystemName();

    public String getCodeSystemCode() {
        return "999";
    }

    protected void addPopupCommandContributions(IMenuManager manager, Object[] selection) {
        List contributions = Extensions.getExtensions((String)"org.eclipse.ui.menus");
        for (IConfigurationElement contributionElement : contributions) {
            IConfigurationElement[] command;
            String locationUri = contributionElement.getAttribute("locationURI");
            String[] parts = locationUri.split(":");
            if (parts.length != 2 || !parts[0].equals("popup") || !parts[1].equals(this.getClass().getName()) || (command = contributionElement.getChildren("command")).length <= 0) continue;
            this.addMenuContribution(command[0], manager, selection);
        }
    }

    protected void addMenuContribution(IConfigurationElement commandElement, IMenuManager manager, Object[] selection) {
        ContributionAction action = new ContributionAction(commandElement);
        if (action.isValid()) {
            action.setSelection(selection);
            manager.add((IAction)action);
        }
    }

    public PersistentObject findElement(String code) {
        String s = String.valueOf(this.getElementClass().getName()) + "::" + code;
        return CoreHub.poFactory.createFromString(s);
    }

    public SelectionDialog getSelectionDialog(Shell parent, Object data) {
        throw new UnsupportedOperationException("SelectionDialog for code system " + this.getCodeSystemName() + " not implemented");
    }

    public static SelectionDialog getSelectionDialog(String codeSystemName, Shell parent, Object data) {
        List list = Extensions.getExtensions((String)"ch.elexis.core.ui.Genericcode");
        list.addAll(Extensions.getExtensions((String)"ch.elexis.core.ui.Verrechnungscode"));
        list.addAll(Extensions.getExtensions((String)"ch.elexis.core.ui.Diagnosecode"));
        if (list != null) {
            for (IConfigurationElement ic : list) {
                Optional<CodeSystemDescription> systemDescription = CodeSystemDescription.of(ic);
                if (systemDescription.isPresent() && codeSystemName.equals(systemDescription.get().getCodeSystemName())) {
                    return systemDescription.get().getSelectionDialog(parent, data);
                }
                systemDescription.ifPresent(description -> {});
            }
        }
        throw new IllegalStateException("Could not find code system " + codeSystemName);
    }

    public static void makeTabs(CTabFolder ctab, IViewSite site, String point) {
        String settings = null;
        if (point.equals("ch.elexis.core.ui.Verrechnungscode")) {
            settings = ConfigServiceHolder.getUser((String)"servicediagnose/srv", null);
        } else if (point.equals("ch.elexis.core.ui.Diagnosecode")) {
            settings = ConfigServiceHolder.getUser((String)"servicediagnose/diagnose", null);
        }
        List list = Extensions.getExtensions((String)point);
        if (settings == null) {
            CodeSelectorFactory.addAllTabs(list, ctab, point);
        } else {
            CodeSelectorFactory.addUserSpecifiedTabs(list, settings, ctab, point);
        }
        if (ctab.getItemCount() > 0) {
            ctab.setSelection(0);
        }
    }

    private static void addAllTabs(List<IConfigurationElement> list, CTabFolder ctab, String point) {
        ITEMS_TO_SHOW_IN_MFU_LIST = ConfigServiceHolder.getUser((String)"mfulist/size", (int)15);
        ctab.setSimple(false);
        if (point.equals("ch.elexis.core.ui.Verrechnungscode")) {
            new FavoritenCTabItem(ctab, 0);
        }
        if (list != null) {
            for (IConfigurationElement ic : list) {
                Optional<CodeSystemDescription> systemDescription = CodeSystemDescription.of(ic);
                if (!systemDescription.isPresent()) continue;
                CTabItem tabItem = new CTabItem(ctab, 0);
                tabItem.setText(systemDescription.get().getCodeSystemName());
                tabItem.setData((Object)systemDescription.get());
            }
        }
    }

    private static void addUserSpecifiedTabs(List<IConfigurationElement> list, String settings, CTabFolder ctab, String point) {
        String[] userSettings;
        HashMap<String, IConfigurationElement> allIcMap = new HashMap<String, IConfigurationElement>();
        for (IConfigurationElement ic : list) {
            try {
                IDetailDisplay d = (IDetailDisplay)ic.createExecutableExtension("CodeDetailDisplay");
                allIcMap.put(d.getTitle(), ic);
            }
            catch (Exception e) {
                ExHandler.handle((Throwable)e);
            }
        }
        String[] stringArray = userSettings = settings.split(",");
        int n = userSettings.length;
        int n2 = 0;
        while (n2 < n) {
            String tab = stringArray[n2];
            if ("Favoriten".equals(tab)) {
                if (point.equals("ch.elexis.core.ui.Verrechnungscode")) {
                    new FavoritenCTabItem(ctab, 0);
                }
            } else {
                Optional<CodeSystemDescription> systemDescription;
                IConfigurationElement ic = (IConfigurationElement)allIcMap.get(tab);
                if (ic != null && (systemDescription = CodeSystemDescription.of(ic)).isPresent()) {
                    CTabItem tabItem = new CTabItem(ctab, 0);
                    tabItem.setText(systemDescription.get().getCodeSystemName());
                    tabItem.setData((Object)systemDescription.get());
                }
            }
            ++n2;
        }
    }

    public boolean hasContextMenu() {
        return this.getSelectionProvider() != null && this.getMenuManager() != null;
    }

    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    public MenuManager getMenuManager() {
        return null;
    }

    public void activateContextMenu(IWorkbenchPartSite site, DelegatingSelectionProvider selectionProvider, String viewId) {
        if (this.hasContextMenu() && site.getPart() != null) {
            selectionProvider.setSelectionProviderDelegate(this.getSelectionProvider());
            site.registerContextMenu(String.valueOf(viewId) + "." + this.getCodeSystemName(), this.getMenuManager(), (ISelectionProvider)selectionProvider);
        }
    }

    protected CommonViewer.PoDoubleClickListener getPoDoubleClickListener() {
        return new CommonViewer.PoDoubleClickListener(){

            @Override
            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                ICodeSelectorTarget target = CodeSelectorHandler.getInstance().getCodeSelectorTarget();
                if (target != null) {
                    if (obj instanceof Leistungsblock) {
                        Leistungsblock block = (Leistungsblock)obj;
                        List elements = block.getElements();
                        for (ICodeElement codeElement : elements) {
                            if (!(codeElement instanceof PersistentObject)) continue;
                            PersistentObject po = (PersistentObject)codeElement;
                            target.codeSelected(po);
                        }
                        List diff = block.getDiffToReferences(elements);
                        if (!diff.isEmpty()) {
                            StringBuilder sb = new StringBuilder();
                            diff.forEach(r -> {
                                if (sb.length() > 0) {
                                    sb.append("\n");
                                }
                                sb.append(r);
                            });
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Warnung", (String)("Warnung folgende Leistungen konnten im aktuellen Kontext (Fall, Konsultation, Gesetz) nicht verrechnet werden.\n" + sb.toString()));
                        }
                    } else {
                        target.codeSelected(obj);
                    }
                }
            }
        };
    }

    public IDoubleClickListener getDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ICodeSelectorTarget target;
                IStructuredSelection structuredSelection;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty() && (target = CodeSelectorHandler.getInstance().getCodeSelectorTarget()) != null) {
                    Object obj = structuredSelection.getFirstElement();
                    target.codeSelected(obj);
                }
            }
        };
    }

    private static class ResizeListener
    extends ControlAdapter {
        private final String k;
        private final SashForm mine;

        ResizeListener(SashForm form, String key) {
            this.k = key;
            this.mine = form;
        }

        public void controlResized(ControlEvent e) {
            int[] weights = this.mine.getWeights();
            StringBuilder v = new StringBuilder();
            v.append(Integer.toString(weights[0])).append(",").append(Integer.toString(weights[1])).append(",").append(Integer.toString(weights[2]));
            ConfigServiceHolder.setUser((String)this.k, (String)v.toString());
        }
    }

    public static class cPage
    extends Composite {
        private CodeElementStatisticsComposite userStatistics;
        private CodeElementStatisticsComposite patientStatistics;
        private CodeSystemDescription description;
        CommonViewer cv;
        ViewerConfigurer vc;
        int[] sashWeights = null;
        ResizeListener resizeListener;
        private final ElexisEventListenerImpl eeli_user = new ElexisUiEventListenerImpl(this, Anwender.class, 64){
            final /* synthetic */ cPage this$1;
            {
                this.this$1 = cPage2;
                super($anonymous0, $anonymous1);
            }

            @Override
            public void runInUi(ElexisEvent ev) {
                if (this.this$1.patientStatistics != null && !this.this$1.patientStatistics.isDisposed()) {
                    this.this$1.patientStatistics.setFont(UiDesk.getFont("anwender/stdfont"));
                }
                if (this.this$1.userStatistics != null && !this.this$1.userStatistics.isDisposed()) {
                    this.this$1.userStatistics.setFont(UiDesk.getFont("anwender/stdfont"));
                }
                if (this.this$1.cv != null && this.this$1.cv.getViewerWidget() != null && !this.this$1.cv.getViewerWidget().getControl().isDisposed()) {
                    this.this$1.cv.getViewerWidget().getControl().setFont(UiDesk.getFont("anwender/stdfont"));
                }
                this.this$1.userStatistics.setContact(ContextServiceHolder.get().getActiveUserContact().orElse(null));
            }
        };

        protected cPage(CTabFolder ctab) {
            super((Composite)ctab, 0);
        }

        cPage(CTabItem ctab, CodeSystemDescription description) {
            super((Composite)ctab.getParent(), 0);
            this.initContent(description);
        }

        cPage(CTabFolder ctab, CodeSystemDescription description) {
            super((Composite)ctab, 0);
            this.initContent(description);
        }

        private void initContent(final CodeSystemDescription description) {
            this.description = description;
            this.setLayout((Layout)new FillLayout());
            SashForm sash = new SashForm((Composite)this, 66048);
            String cfgKey = "ansicht/codesystem/" + description.getCodeSystemName();
            this.resizeListener = new ResizeListener(sash, cfgKey);
            String sashW = ConfigServiceHolder.getUser((String)cfgKey, (String)"20,20,60");
            this.sashWeights = new int[3];
            int i = 0;
            String[] stringArray = sashW.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sw = stringArray[n2];
                this.sashWeights[i++] = Integer.parseInt(sw);
                ++n2;
            }
            this.userStatistics = new CodeElementStatisticsComposite(description.getElexisClassName(), (Composite)sash, 0);
            this.userStatistics.setTitle(Messages.CodeSelectorFactory_yourMostFrequent);
            this.userStatistics.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
            this.patientStatistics = new CodeElementStatisticsComposite(description.getElexisClassName(), (Composite)sash, 0);
            this.patientStatistics.setTitle(Messages.CodeSelectorFactory_patientsMostFrequent);
            this.patientStatistics.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
            Group gAll = new Group((Composite)sash, 0);
            gAll.setText(Messages.CodeSelectorFactory_all);
            gAll.setLayout((Layout)new GridLayout());
            this.cv = new CommonViewer();
            List<Object> actions = description.getActions(null);
            if (actions != null) {
                MenuManager menu = new MenuManager();
                menu.setRemoveAllWhenShown(true);
                menu.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        List<Object> actions = description.getActions(null);
                        for (IAction iAction : actions) {
                            manager.add(iAction);
                        }
                    }
                });
                this.cv.setContextMenu(menu);
            }
            this.vc = description.getCodeSelectorFactory().createViewerConfigurer(this.cv);
            if (this.vc.getContentType() == ViewerConfigurer.ContentType.GENERICOBJECT) {
                this.vc.setDoubleClickListener(description.getCodeSelectorFactory().getDoubleClickListener());
            }
            Composite cvc = new Composite((Composite)gAll, 0);
            cvc.setLayout((Layout)new GridLayout());
            cvc.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.cv.create(this.vc, cvc, 0, (Object)this);
            this.cv.getViewerWidget().getControl().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.vc.getContentProvider().startListening();
            if (this.vc.getContentType() == ViewerConfigurer.ContentType.PERSISTENTOBJECT) {
                this.cv.addDoubleClickListener(description.getCodeSelectorFactory().getPoDoubleClickListener());
            }
            try {
                sash.setWeights(this.sashWeights);
            }
            catch (Throwable t) {
                ExHandler.handle((Throwable)t);
                sash.setWeights(new int[]{20, 20, 60});
            }
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_user});
            this.refresh();
        }

        public void dispose() {
            this.vc.getContentProvider().stopListening();
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_user});
            super.dispose();
        }

        public void refresh() {
            this.patientStatistics.setContact(ContextServiceHolder.get().getActivePatient().orElse(null));
            this.userStatistics.setContact(ContextServiceHolder.get().getActiveUserContact().orElse(null));
        }
    }
}

