/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.codesystems;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.DelegatingSelectionProvider;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.FavoritenCTabItem;
import ch.elexis.core.ui.views.IDetailDisplay;
import ch.elexis.core.ui.views.MakrosCTabItem;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.core.ui.views.codesystems.Messages;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.LoggerFactory;

public class CodeDetailView
extends ViewPart
implements IActivationListener {
    public static final String ID = "ch.elexis.codedetailview";
    private CTabFolder ctab;
    private IAction importAction;
    private ViewMenus viewmenus;
    private Hashtable<String, ImporterPage> importers;
    private DelegatingSelectionProvider delegatingSelectionProvider;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.ctab = new CTabFolder(parent, 0);
        this.importers = new Hashtable();
        this.addAllPages();
        if (this.ctab.getItemCount() > 0) {
            this.ctab.setSelection(0);
        }
        this.ctab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MasterDetailsPage page;
                CTabItem selected = CodeDetailView.this.ctab.getSelection();
                if (selected != null && selected.getControl() instanceof MasterDetailsPage && (page = (MasterDetailsPage)selected.getControl()).getCodeSelectorFactory().hasContextMenu()) {
                    page.getCodeSelectorFactory().activateContextMenu(CodeDetailView.this.getSite(), CodeDetailView.this.delegatingSelectionProvider, CodeDetailView.ID);
                }
                if (selected instanceof FavoritenCTabItem || selected instanceof MakrosCTabItem) {
                    return;
                }
                if (selected != null) {
                    String t = selected.getText();
                    CodeDetailView.this.importAction.setEnabled(CodeDetailView.this.importers.get(t) != null);
                    MasterDetailsPage page2 = (MasterDetailsPage)selected.getControl();
                    ViewerConfigurer vc = page2.cv.getConfigurer();
                    vc.getControlFieldProvider().setFocus();
                }
            }
        });
        this.makeActions();
        this.viewmenus = new ViewMenus(this.getViewSite());
        this.viewmenus.createMenu(this.importAction);
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
        this.delegatingSelectionProvider = new DelegatingSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.delegatingSelectionProvider);
    }

    private void makeActions() {
        this.importAction = new Action(Messages.CodeDetailView_importActionTitle){

            public void run() {
                ImporterPage top;
                CTabItem it = CodeDetailView.this.ctab.getSelection();
                if (it != null && (top = CodeDetailView.this.importers.get(it.getText())) != null) {
                    ImportDialog dlg = new ImportDialog(CodeDetailView.this.getViewSite().getShell(), top);
                    dlg.create();
                    dlg.setTitle(top.getTitle());
                    dlg.setMessage(top.getDescription());
                    dlg.getShell().setText(Messages.CodeDetailView_importerCaption);
                    if (dlg.open() == 0) {
                        top.run(false);
                    }
                }
            }
        };
    }

    private void addAllPages() {
        String settings = ConfigServiceHolder.getUser((String)"servicediagnose/codes", null);
        if (settings == null) {
            new MakrosCTabItem(this.ctab, 0);
            new FavoritenCTabItem(this.ctab, 0);
            this.addPagesFor("ch.elexis.core.ui.Diagnosecode");
            this.addPagesFor("ch.elexis.core.ui.Verrechnungscode");
            this.addPagesFor("ch.elexis.core.ui.Genericcode");
        } else {
            new MakrosCTabItem(this.ctab, 0);
            this.addUserSpecifiedPages(settings);
        }
    }

    private void addUserSpecifiedPages(String settings) {
        String[] userSettings = settings.split(",");
        Map<Integer, IConfigurationElement> iceMap = new TreeMap<Integer, IConfigurationElement>();
        iceMap = this.collectNeededPages("ch.elexis.core.ui.Diagnosecode", userSettings, iceMap);
        iceMap = this.collectNeededPages("ch.elexis.core.ui.Verrechnungscode", userSettings, iceMap);
        iceMap = this.collectNeededPages("ch.elexis.core.ui.Genericcode", userSettings, iceMap);
        int i = 0;
        while (i < userSettings.length) {
            if (userSettings[i].equals("Favoriten")) {
                iceMap.put(i, null);
            }
            ++i;
        }
        for (Integer key : iceMap.keySet()) {
            IConfigurationElement ce = iceMap.get(key);
            if (ce == null) {
                new FavoritenCTabItem(this.ctab, 0);
                continue;
            }
            try {
                IDetailDisplay detailDisplay = (IDetailDisplay)ce.createExecutableExtension("CodeDetailDisplay");
                CodeSelectorFactory codeSelector = (CodeSelectorFactory)ce.createExecutableExtension("CodeSelectorFactory");
                String a = ce.getAttribute("ImporterClass");
                ImporterPage ip = null;
                if (a != null && (ip = (ImporterPage)ce.createExecutableExtension("ImporterClass")) != null) {
                    this.importers.put(detailDisplay.getTitle(), ip);
                }
                MasterDetailsPage page = new MasterDetailsPage((Composite)this.ctab, codeSelector, detailDisplay);
                CTabItem ct = new CTabItem(this.ctab, 0);
                ct.setText(detailDisplay.getTitle());
                ct.setControl((Control)page);
                ct.setData((Object)detailDisplay);
                CoreUiUtil.injectServices(codeSelector);
                CoreUiUtil.injectServices(detailDisplay);
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(this.getClass()).error("Error creating pages", (Throwable)ex);
                ElexisStatus status = new ElexisStatus(2, "ch.elexis.core.ui", 0, "Fehler beim Initialisieren von " + ce.getName(), ex, 3);
                StatusManager.getManager().handle((IStatus)status, 2);
            }
        }
    }

    private Map<Integer, IConfigurationElement> collectNeededPages(String point, String[] userSettings, Map<Integer, IConfigurationElement> iceMap) {
        List list = Extensions.getExtensions((String)point);
        for (IConfigurationElement ce : list) {
            try {
                if ("Artikel".equals(ce.getName())) continue;
                IDetailDisplay d = (IDetailDisplay)ce.createExecutableExtension("CodeDetailDisplay");
                int i = 0;
                while (i < userSettings.length) {
                    if (userSettings[i].equals(d.getTitle().trim())) {
                        iceMap.put(i, ce);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ElexisStatus status = new ElexisStatus(2, "ch.elexis.core.ui", 0, "Fehler beim Initialisieren von " + ce.getName(), ex, 3);
                StatusManager.getManager().handle((IStatus)status, 2);
            }
        }
        return iceMap;
    }

    private void addPagesFor(String point) {
        List list = Extensions.getExtensions((String)point);
        for (IConfigurationElement ce : list) {
            try {
                if ("Artikel".equals(ce.getName())) continue;
                IDetailDisplay detailDisplay = (IDetailDisplay)ce.createExecutableExtension("CodeDetailDisplay");
                CodeSelectorFactory codeSelector = (CodeSelectorFactory)ce.createExecutableExtension("CodeSelectorFactory");
                String a = ce.getAttribute("ImporterClass");
                ImporterPage ip = null;
                if (a != null && (ip = (ImporterPage)ce.createExecutableExtension("ImporterClass")) != null) {
                    this.importers.put(detailDisplay.getTitle(), ip);
                }
                MasterDetailsPage page = new MasterDetailsPage((Composite)this.ctab, codeSelector, detailDisplay);
                CTabItem ct = new CTabItem(this.ctab, 0);
                ct.setText(detailDisplay.getTitle());
                ct.setControl((Control)page);
                ct.setData((Object)detailDisplay);
                CoreUiUtil.injectServicesWithContext(codeSelector);
                CoreUiUtil.injectServicesWithContext(detailDisplay);
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(this.getClass()).error("Error creating pages", (Throwable)ex);
                ElexisStatus status = new ElexisStatus(2, "ch.elexis.core.ui", 0, "Fehler beim Initialisieren von " + ce.getName(), ex, 3);
                StatusManager.getManager().handle((IStatus)status, 2);
            }
        }
    }

    public void setFocus() {
        if (this.ctab.getItemCount() > 0) {
            this.ctab.setFocus();
        }
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        if (this.ctab != null && !this.ctab.isDisposed()) {
            CTabItem[] cTabItemArray = this.ctab.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem ct = cTabItemArray[n2];
                MasterDetailsPage page = (MasterDetailsPage)ct.getControl();
                page.cv.getConfigurer().getContentProvider().stopListening();
                page.dispose();
                ++n2;
            }
        }
    }

    @Override
    public void activation(boolean mode) {
        CTabItem selected = this.ctab.getSelection();
        if (selected instanceof FavoritenCTabItem || selected instanceof MakrosCTabItem) {
            return;
        }
        if (selected != null) {
            MasterDetailsPage page = (MasterDetailsPage)selected.getControl();
            ViewerConfigurer vc = page.cv.getConfigurer();
            if (mode) {
                vc.getControlFieldProvider().setFocus();
            } else {
                vc.getControlFieldProvider().clearValues();
            }
        }
    }

    @Override
    public void visible(boolean mode) {
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout(part, currentState);
    }

    private class ImportDialog
    extends TitleAreaDialog {
        ImporterPage importer;

        public ImportDialog(Shell parentShell, ImporterPage i) {
            super(parentShell);
            this.importer = i;
        }

        protected Control createDialogArea(Composite parent) {
            return this.importer.createPage(parent);
        }
    }

    private class MasterDetailsPage
    extends Composite {
        private SashForm sash;
        private CommonViewer cv;
        private CodeSelectorFactory master;
        private IDetailDisplay detail;
        private ElexisEventListenerImpl eeli_div;
        private ElexisEventListenerImpl eeli_mod;

        public MasterDetailsPage(Composite parent, CodeSelectorFactory codeSelectorFactory, IDetailDisplay displayDetail) {
            super(parent, 0);
            this.detail = displayDetail;
            this.master = codeSelectorFactory;
            this.cv = new CommonViewer();
            this.eeli_div = new ElexisUiEventListenerImpl(this.detail.getElementClass(), 16){

                @Override
                public void runInUi(ElexisEvent ev) {
                    MasterDetailsPage.this.detail.display(ev.getObject());
                }
            };
            this.eeli_mod = new ElexisUiEventListenerImpl(this.detail.getElementClass(), 4){

                @Override
                public void runInUi(ElexisEvent ev) {
                    MasterDetailsPage.this.cv.notify(CommonViewer.Message.updateSingle, ev.getObject());
                }
            };
            this.setLayout((Layout)new FillLayout());
            this.sash = new SashForm((Composite)this, 0);
            this.cv.setViewName(this.master.getCodeSystemName());
            this.cv.create(this.master.createViewerConfigurer(this.cv), (Composite)this.sash, 0, CodeDetailView.this.getViewSite());
            this.detail.createDisplay((Composite)this.sash, CodeDetailView.this.getViewSite());
            this.cv.getConfigurer().getContentProvider().startListening();
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_div, this.eeli_mod});
        }

        public CodeSelectorFactory getCodeSelectorFactory() {
            return this.master;
        }

        public void dispose() {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_div, this.eeli_mod});
        }
    }
}

