/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.artikel;

import ch.elexis.core.data.service.StockServiceHolder;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.ui.commands.EditEigenartikelUi;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.artikel.Messages;
import ch.elexis.core.ui.views.codesystems.CodeSystemDescription;
import ch.elexis.core.ui.views.provider.StockEntryLabelProvider;
import ch.elexis.data.PersistentObject;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.part.ViewPart;

public class ArtikelSelektor
extends ViewPart {
    public static final String ID = "ch.elexis.ArtikelSelektor";
    CTabFolder ctab;
    TableViewer tv;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.ctab = new CTabFolder(parent, 0);
        this.ctab.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        List list = Extensions.getExtensions((String)"ch.elexis.core.ui.Verrechnungscode");
        this.ctab.addSelectionListener((SelectionListener)new TabSelectionListener());
        for (IConfigurationElement ice : list) {
            Optional<CodeSystemDescription> description;
            if (!"Artikel".equals(ice.getName()) || !(description = CodeSystemDescription.of(ice)).isPresent()) continue;
            CTabItem ci = new CTabItem(this.ctab, 0);
            ci.setText(description.get().getCodeSystemName());
            ci.setData((Object)description.get());
        }
        CTabItem ci = new CTabItem(this.ctab, 0);
        Composite c = new Composite((Composite)this.ctab, 0);
        c.setLayout((Layout)new GridLayout());
        ci.setControl((Control)c);
        ci.setText(Messages.ArtikelSelector_stockArticles);
        Table table = new Table(c, 576);
        table.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.tv = new TableViewer(table);
        this.tv.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tv.setLabelProvider((IBaseLabelProvider)new StockEntryLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                IStockEntry se = (IStockEntry)element;
                if (se.getArticle() != null) {
                    String ret = se.getArticle().getName();
                    Long amount = StockServiceHolder.get().getCumulatedStockForArticle(se.getArticle());
                    if (amount != null) {
                        ret = String.valueOf(ret) + " (" + Long.toString(amount) + ")";
                    }
                    return ret;
                }
                return se.getLabel();
            }
        });
        StockEntryLoader loader = new StockEntryLoader((Viewer)this.tv);
        loader.schedule();
    }

    public void setFocus() {
    }

    public void dispose() {
    }

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout(part, currentState);
    }

    private static class StockEntryLoader
    extends Job {
        private Viewer viewer;
        private List<IStockEntry> loaded;

        public StockEntryLoader(Viewer viewer) {
            super("Stock loading ...");
            this.viewer = viewer;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Stock loading ...", -1);
            this.loaded = StockServiceHolder.get().getAllStockEntries();
            this.loaded.sort(this.compareArticleLabel());
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    viewer.setInput(loaded);
                }
            });
            return Status.OK_STATUS;
        }

        private Comparator<IStockEntry> compareArticleLabel() {
            return Comparator.comparing(o -> o.getArticle() != null ? o.getArticle().getLabel() : null, Comparator.nullsLast(Comparator.naturalOrder()));
        }
    }

    private class TabSelectionListener
    extends SelectionAdapter {
        private TabSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            CTabItem top = ArtikelSelektor.this.ctab.getSelection();
            if (top != null && top.getControl() == null) {
                CommonViewer cv = new CommonViewer();
                CodeSystemDescription description = (CodeSystemDescription)top.getData();
                ViewerConfigurer vc = description.getCodeSelectorFactory().createViewerConfigurer(cv);
                Composite c = new Composite((Composite)ArtikelSelektor.this.ctab, 0);
                c.setLayout((Layout)new GridLayout());
                cv.create(vc, c, 512, ArtikelSelektor.this.getViewSite());
                top.setControl((Control)c);
                top.setData((Object)cv);
                cv.addDoubleClickListener(new CommonViewer.PoDoubleClickListener(){

                    @Override
                    public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                        EditEigenartikelUi.executeWithParams(obj);
                    }
                });
                vc.getContentProvider().startListening();
            }
        }
    }
}

