/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.ICodeElement;
import ch.elexis.core.data.interfaces.IOutputter;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IRecipe;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IPrescriptionBuilder;
import ch.elexis.core.model.builder.IRecipeBuilder;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.dialogs.MediDetailDialog;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.GenericObjectDragSource;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.RezeptBlatt;
import ch.elexis.core.ui.views.codesystems.CodeSystemDescription;
import ch.elexis.core.ui.views.codesystems.LeistungenView;
import ch.elexis.data.Artikel;
import ch.elexis.data.Brief;
import ch.elexis.data.OutputLog;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.Rezept;
import ch.rgw.tools.ExHandler;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class RezepteView
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.Rezepte";
    private final FormToolkit tk = UiDesk.getToolkit();
    private Form master;
    TableViewer tv;
    ListViewer lvRpLines;
    private Action newRpAction;
    private Action deleteRpAction;
    private Action addLineAction;
    private Action removeLineAction;
    private Action changeMedicationAction;
    private ViewMenus menus;
    private Action printAction;
    private GenericObjectDropTarget dropTarget;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);
    private IPatient actPatient;
    private RecipeLoader loader;
    @Inject
    private ICodeElementService codeElementService;

    @Inject
    void activePatient(@Optional IPatient patient) {
        this.actPatient = patient;
        Display.getDefault().asyncExec(() -> {
            if (CoreUiUtil.isActiveControl(this.tv.getControl())) {
                this.tv.setInput(Collections.emptyList());
            }
            ContextServiceHolder.get().getRootContext().removeTyped(IRecipe.class);
            if (patient != null) {
                this.addLineAction.setEnabled(false);
                this.printAction.setEnabled(false);
                this.master.setText(patient.getLabel());
            }
            this.refresh();
        });
    }

    @Inject
    void activeRecipe(@Optional IRecipe recipe) {
        Display.getDefault().asyncExec(() -> {
            if (this.tv != null && this.tv.getControl() != null && !this.tv.getControl().isDisposed()) {
                this.refreshRecipe();
            }
        });
    }

    @Optional
    @Inject
    void udpateRecipe(@UIEventTopic(value="info/elexis/model/update") IRecipe recipe) {
        if (this.tv != null && this.tv.getControl() != null && !this.tv.getControl().isDisposed()) {
            this.tv.refresh(true);
        }
    }

    public void createPartControl(Composite parent) {
        this.setTitleImage(Images.IMG_VIEW_RECIPES.getImage());
        parent.setLayout((Layout)new GridLayout());
        this.master = this.tk.createForm(parent);
        this.master.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.master.getBody().setLayout((Layout)new FillLayout());
        SashForm sash = new SashForm(this.master.getBody(), 0);
        this.tv = new TableViewer((Composite)sash, 66048);
        this.tv.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IRecipe) {
                    IRecipe rp = (IRecipe)element;
                    return rp.getLabel();
                }
                return element.toString();
            }

            public Image getImage(Object element) {
                OutputLog o;
                String outputterID;
                IOutputter io;
                List outputs;
                if (element instanceof IRecipe) {
                    element = Rezept.load((String)((IRecipe)element).getId());
                }
                if ((outputs = OutputLog.getOutputs((PersistentObject)((PersistentObject)element))) != null && outputs.size() > 0 && (io = OutputLog.getOutputter((String)(outputterID = (o = (OutputLog)outputs.get(0)).getOutputterID()))) != null) {
                    return (Image)io.getSymbol();
                }
                return null;
            }
        });
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getStructuredSelection().getFirstElement() instanceof IRecipe) {
                    ContextServiceHolder.get().getRootContext().setNamed(ContextServiceHolder.SELECTIONFALLBACK, event.getStructuredSelection().getFirstElement());
                }
            }
        });
        this.lvRpLines = new ListViewer((Composite)sash);
        this.makeActions();
        this.menus = new ViewMenus(this.getViewSite());
        this.menus.createMenu(new IAction[]{this.newRpAction, this.addLineAction, this.printAction, this.deleteRpAction});
        this.menus.createViewerContextMenu((StructuredViewer)this.lvRpLines, new IAction[]{this.removeLineAction, this.changeMedicationAction});
        this.getSite().setSelectionProvider((ISelectionProvider)this.lvRpLines);
        IToolBarManager tm = this.getViewSite().getActionBars().getToolBarManager();
        List importers = Extensions.getClasses((List)Extensions.getExtensions((String)"ch.elexis.core.ui.RezeptHook"), (String)"RpToolbarAction", (boolean)false);
        for (IAction ac : importers) {
            tm.add(ac);
        }
        if (importers.size() > 0) {
            tm.add((IContributionItem)new Separator());
        }
        tm.add((IAction)this.newRpAction);
        tm.add((IAction)this.addLineAction);
        tm.add((IAction)this.printAction);
        this.tv.setInput((Object)this.getViewSite());
        GenericObjectDropTarget.IReceiver dtr = new GenericObjectDropTarget.IReceiver(){

            @Override
            public void dropped(List<Object> list, DropTargetEvent e) {
                for (Object obj : list) {
                    IPrescription ret;
                    IRecipe recipe = ContextServiceHolder.get().getTyped(IRecipe.class).orElse(null);
                    if (recipe == null) {
                        SWTHelper.showError(Messages.RezepteView_NoPrescriptionSelected, Messages.RezepteView_PleaseChoosaAPrescription);
                        return;
                    }
                    if (obj instanceof IArticle) {
                        IArticle art = (IArticle)obj;
                        ret = (IPrescription)new IPrescriptionBuilder(CoreModelServiceHolder.get(), ContextServiceHolder.get(), art, recipe.getPatient(), "").build();
                        ret.setRemark("");
                        ret.setEntryType(EntryType.RECIPE);
                        ret.setRecipe(recipe);
                        CoreModelServiceHolder.get().save((Identifiable)ret);
                        RezepteView.this.refreshRecipe();
                        continue;
                    }
                    if (!(obj instanceof IPrescription)) continue;
                    IPrescription pre = (IPrescription)obj;
                    ret = (IPrescription)new IPrescriptionBuilder(CoreModelServiceHolder.get(), ContextServiceHolder.get(), pre.getArticle(), recipe.getPatient(), pre.getDosageInstruction()).build();
                    ret.setRemark(pre.getRemark());
                    ret.setEntryType(EntryType.RECIPE);
                    ret.setRecipe(recipe);
                    CoreModelServiceHolder.get().save((Identifiable)ret);
                    RezepteView.this.refreshRecipe();
                }
            }

            @Override
            public boolean accept(List<Object> list) {
                return true;
            }
        };
        this.dropTarget = new GenericObjectDropTarget("Rezept", this.lvRpLines.getControl(), dtr);
        this.lvRpLines.setContentProvider((IContentProvider)new RezeptContentProvider());
        this.lvRpLines.setLabelProvider((IBaseLabelProvider)new RezeptLabelProvider());
        this.lvRpLines.getControl().setToolTipText(Messages.RezepteView_DragMedicamentsHere);
        new GenericObjectDragSource((StructuredViewer)this.lvRpLines);
        this.lvRpLines.setInput((Object)this.getViewSite());
        this.addLineAction.setEnabled(false);
        this.printAction.setEnabled(false);
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    IRecipe recipe;
                    RezeptBlatt rp = (RezeptBlatt)RezepteView.this.getViewSite().getPage().showView("ch.elexis.RezeptBlatt");
                    if (event.getSelection() instanceof StructuredSelection && (recipe = (IRecipe)((StructuredSelection)event.getSelection()).getFirstElement()) != null) {
                        Rezept rezept = Rezept.load((String)recipe.getId());
                        IDocumentLetter document = recipe.getDocument();
                        if (document != null) {
                            rp.loadRezeptFromDatabase(rezept, Brief.load((String)document.getId()));
                        } else {
                            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)rezept);
                            rp.createRezept(rezept);
                            CoreModelServiceHolder.get().refresh((Identifiable)recipe, true);
                            RezepteView.this.refresh();
                        }
                    }
                }
                catch (Throwable ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        });
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void setFocus() {
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
    }

    @Override
    public void refresh() {
        if (CoreUiUtil.isActiveControl(this.tv.getControl())) {
            if (this.loader != null) {
                this.loader.cancel();
            }
            this.loader = new RecipeLoader((Viewer)this.tv, this.actPatient);
            this.loader.schedule();
        }
    }

    public void refreshRecipe() {
        IRecipe recipe = ContextServiceHolder.get().getTyped(IRecipe.class).orElse(null);
        if (recipe == null) {
            this.lvRpLines.refresh(true);
            this.addLineAction.setEnabled(false);
            this.printAction.setEnabled(false);
        } else {
            this.lvRpLines.refresh(true);
            this.addLineAction.setEnabled(true);
            this.printAction.setEnabled(true);
        }
    }

    private void makeActions() {
        this.newRpAction = new Action(Messages.RezepteView_newPrescriptionAction){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.RezepteView_newPrescriptonTooltip);
            }

            public void run() {
                IEncounter k;
                IPatient patient = ContextServiceHolder.get().getActivePatient().orElse(null);
                if (patient == null) {
                    MessageBox mb = new MessageBox(RezepteView.this.getViewSite().getShell(), 34);
                    mb.setText(Messages.RezepteView_newPrescriptionError);
                    mb.setMessage(Messages.RezepteView_noPatientSelected);
                    mb.open();
                    return;
                }
                ICoverage coverage = ContextServiceHolder.get().getActiveCoverage().orElse(null);
                if (coverage == null && (k = (IEncounter)EncounterServiceHolder.get().getLatestEncounter(patient).orElse(null)) == null) {
                    SWTHelper.alert(Messages.RezepteView_noCaseSelected, Messages.RezepteView_pleaseCreateOrChooseCase);
                    return;
                }
                IRecipe recipe = (IRecipe)new IRecipeBuilder(CoreModelServiceHolder.get(), patient, (IMandator)ContextServiceHolder.get().getActiveMandator().orElse(null)).buildAndSave();
                RezepteView.this.refresh();
                RezepteView.this.doSelectNewRezept(recipe);
                RezepteView.this.doAddLine();
            }
        };
        this.deleteRpAction = new Action(Messages.RezepteView_deletePrescriptionActiom){

            public void run() {
                IRecipe recipe = ContextServiceHolder.get().getTyped(IRecipe.class).orElse(null);
                if (MessageDialog.openConfirm((Shell)RezepteView.this.getViewSite().getShell(), (String)Messages.RezepteView_deletePrescriptionActiom, (String)MessageFormat.format(Messages.RezepteView_deletePrescriptionConfirm, recipe.getDate()))) {
                    CoreModelServiceHolder.get().delete((Deleteable)recipe);
                    RezepteView.this.refresh();
                }
            }
        };
        this.removeLineAction = new Action(Messages.RezepteView_deleteLineAction){

            public void run() {
                IRecipe rp = ContextServiceHolder.get().getTyped(IRecipe.class).orElse(null);
                IStructuredSelection sel = (IStructuredSelection)RezepteView.this.lvRpLines.getSelection();
                IPrescription p = (IPrescription)sel.getFirstElement();
                if (rp != null && p != null) {
                    rp.removePrescription(p);
                    RezepteView.this.lvRpLines.refresh();
                }
            }
        };
        this.addLineAction = new Action(Messages.RezepteView_newLineAction){

            public void run() {
                RezepteView.this.doAddLine();
            }
        };
        this.printAction = new Action(Messages.RezepteView_printAction){

            public void run() {
                try {
                    IRecipe recipe = ContextServiceHolder.get().getTyped(IRecipe.class).orElse(null);
                    if (recipe != null) {
                        Rezept rezept = Rezept.load((String)recipe.getId());
                        RezeptBlatt rp = (RezeptBlatt)RezepteView.this.getViewSite().getPage().showView("ch.elexis.RezeptBlatt");
                        IDocumentLetter document = recipe.getDocument();
                        if (document == null) {
                            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)rezept);
                            rp.createRezept(rezept);
                        } else {
                            Brief rpBrief = Brief.load((String)document.getId());
                            String[] dialogButtonLabels = new String[]{Messages.RezepteView_RecreatePrescription, Messages.RezepteView_ShowPrescription, Messages.RezepteView_PrescriptionCancel};
                            MessageDialog msg2 = new MessageDialog(null, Messages.RezepteView_CreatePrescription, null, Messages.RezepteView_ReallyWantToRecreatePrescription, 4, dialogButtonLabels, 2);
                            int result = msg2.open();
                            switch (result) {
                                case 0: {
                                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)rezept);
                                    rp.createRezept(rezept);
                                    break;
                                }
                                case 1: {
                                    rp.loadRezeptFromDatabase(rezept, rpBrief);
                                    break;
                                }
                            }
                        }
                        CoreModelServiceHolder.get().refresh((Identifiable)recipe, true);
                        RezepteView.this.refresh();
                    }
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        };
        this.changeMedicationAction = new RestrictedAction(AccessControlDefaults.MEDICATION_MODIFY, Messages.RezepteView_ChangeLink){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.RezepteView_ChangeTooltip);
            }

            @Override
            public void doRun() {
                IStructuredSelection sel = (IStructuredSelection)RezepteView.this.lvRpLines.getSelection();
                IPrescription pr = (IPrescription)sel.getFirstElement();
                if (pr != null) {
                    new MediDetailDialog(RezepteView.this.getViewSite().getShell(), pr).open();
                    CoreModelServiceHolder.get().save((Identifiable)pr);
                    RezepteView.this.refreshRecipe();
                }
            }
        };
        this.addLineAction.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
        this.printAction.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
        this.deleteRpAction.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
    }

    private void doSelectNewRezept(IRecipe rezept) {
        this.tv.getTable().setFocus();
        this.tv.setSelection((ISelection)new StructuredSelection((Object)rezept), true);
        ContextServiceHolder.get().getRootContext().setTyped((Object)rezept);
    }

    private void doAddLine() {
        try {
            LeistungenView lv1 = (LeistungenView)this.getViewSite().getPage().showView("ch.elexis.LeistungenView");
            CodeSelectorHandler.getInstance().setCodeSelectorTarget(this.dropTarget);
            CTabItem[] tabItems = lv1.ctab.getItems();
            List articleCodeContributions = this.codeElementService.getContributionsByTyp(ICodeElementService.CodeElementTyp.ARTICLE);
            CTabItem[] cTabItemArray = tabItems;
            int n = tabItems.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem tab = cTabItemArray[n2];
                if (tab.getData() instanceof ICodeElement) {
                    ICodeElement ics = (ICodeElement)tab.getData();
                    if (ics instanceof Artikel) {
                        lv1.ctab.setSelection(tab);
                        lv1.setSelected(tab);
                        break;
                    }
                } else if (tab.getData() instanceof CodeSystemDescription) {
                    CodeSystemDescription desc = (CodeSystemDescription)tab.getData();
                    if (articleCodeContributions.stream().filter(ac -> ac.getSystem().equals(desc.getCodeSystemName())).findFirst().isPresent()) {
                        lv1.ctab.setSelection(tab);
                        lv1.setSelected(tab);
                        break;
                    }
                }
                ++n2;
            }
            lv1.setFocus();
        }
        catch (PartInitException ex) {
            ExHandler.handle((Throwable)ex);
        }
    }

    public void clearEvent(Class<? extends PersistentObject> template) {
        this.lvRpLines.refresh();
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout(part, currentState);
    }

    private static class RecipeLoader
    extends Job {
        private Viewer viewer;
        private IPatient patient;
        private List<IRecipe> loaded;

        public RecipeLoader(Viewer viewer, IPatient patient) {
            super("Recipe loading ...");
            this.viewer = viewer;
            this.patient = patient;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Recipe loading ...", -1);
            if (this.patient != null) {
                INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(IRecipe.class, new String[]{"patient"});
                this.loaded = query.executeWithParameters(query.getParameterMap(new Object[]{"patient", this.patient}));
            } else {
                this.loaded = Collections.emptyList();
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (viewer != null && !viewer.getControl().isDisposed()) {
                        viewer.setInput(loaded);
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }

    private static class RezeptContentProvider
    implements IStructuredContentProvider {
        private RezeptContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IRecipe recipe = ContextServiceHolder.get().getTyped(IRecipe.class).orElse(null);
            if (recipe == null) {
                return new Prescription[0];
            }
            List list = recipe.getPrescriptions();
            return list.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class RezeptLabelProvider
    extends LabelProvider {
        private RezeptLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IPrescription) {
                IPrescription z = (IPrescription)element;
                return z.getLabel();
            }
            return "?";
        }
    }
}

