/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Anwender;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class FieldDisplayView
extends ViewPart
implements IActivationListener,
ElexisEventListener,
Heartbeat.HeartListener {
    public static final String ID = "ch.elexis.dbfielddisplay";
    private IAction newViewAction;
    private IAction editDataAction;
    Text text;
    Class<? extends PersistentObject> myClass;
    String myField;
    boolean bCanEdit;
    ScrolledForm form;
    FormToolkit tk = UiDesk.getToolkit();
    String subid;
    String NODE = "FeldAnzeige";
    private final ElexisEvent template = new ElexisEvent(null, this.myClass, 48);

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.form = this.tk.createScrolledForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.form.getBody().setLayout((Layout)new GridLayout());
        this.text = this.tk.createText(this.form.getBody(), "", 514);
        this.text.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                IPersistentObject mine;
                if (FieldDisplayView.this.bCanEdit && (mine = ElexisEventDispatcher.getSelected(FieldDisplayView.this.myClass)) != null) {
                    mine.set(FieldDisplayView.this.myField, FieldDisplayView.this.text.getText());
                }
            }
        });
        this.text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent arg0) {
                arg0.doit = FieldDisplayView.this.bCanEdit;
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createToolbar(this.newViewAction, this.editDataAction);
        String nx = "Patient.Diagnosen";
        Integer canEdit = null;
        this.subid = this.getViewSite().getSecondaryId();
        if (this.subid == null) {
            this.subid = "defaultData";
        }
        nx = ConfigServiceHolder.getUser((String)("FieldDisplayViewData/" + this.subid), null);
        canEdit = ConfigServiceHolder.getUser((String)("FieldDisplayViewCanEdit/" + this.subid), (int)0);
        this.setField(nx == null ? "Patient.Diagnosen" : nx, canEdit == null ? false : canEdit != 0);
        GlobalEventDispatcher.addActivationListener(this, this.getViewSite().getPart());
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener(this, this.getViewSite().getPart());
    }

    public void setFocus() {
        this.text.setFocus();
    }

    @Override
    public void activation(boolean mode) {
    }

    @Override
    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this});
            CoreHub.heart.addListener((Heartbeat.HeartListener)this);
            this.heartbeat();
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this});
            CoreHub.heart.removeListener((Heartbeat.HeartListener)this);
        }
    }

    public void catchElexisEvent(final ElexisEvent ev) {
        final PersistentObject po = ev.getObject();
        if (po != null && ev.getObjectClass().equals(this.myClass)) {
            UiDesk.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ev.getType() == 16) {
                        String val = po.get(FieldDisplayView.this.myField);
                        if (val == null) {
                            SWTHelper.showError(Messages.FieldDisplayView_ErrorFieldCaption, String.valueOf(Messages.FieldDisplayView_ErrorFieldBody) + FieldDisplayView.this.myField);
                            FieldDisplayView.this.text.setText("");
                        } else {
                            FieldDisplayView.this.text.setText(po.get(FieldDisplayView.this.myField));
                        }
                    } else if (ev.getType() == 32) {
                        FieldDisplayView.this.text.setText("");
                    }
                }
            });
        } else if (ev.getClass().equals(Anwender.class)) {
            String nx = ConfigServiceHolder.getUser((String)("FieldDisplayViewData/" + this.subid), null);
            Integer canEdit = ConfigServiceHolder.getUser((String)("FieldDisplayViewCanEdit/" + this.subid), (int)0);
            this.setField(nx == null ? "Patient.Diagnosen" : nx, canEdit == null ? false : canEdit != 0);
        }
    }

    public ElexisEvent getElexisEventFilter() {
        return this.template;
    }

    public void heartbeat() {
        IPersistentObject mine = ElexisEventDispatcher.getSelected(this.myClass);
        if (mine == null) {
            this.catchElexisEvent(new ElexisEvent(mine, this.myClass, 32));
        } else {
            this.catchElexisEvent(new ElexisEvent(mine, this.myClass, 16));
        }
    }

    private void setField(String field, boolean canEdit) {
        String[] def = field.split("\\.");
        if (def.length != 2) {
            SWTHelper.showError(Messages.FieldDisplayView_BadDefinitionCaption, Messages.FieldDisplayView_BadDefinitionBody);
        } else {
            this.myClass = this.resolveName(def[0]);
            if (this.myClass != null) {
                this.myField = def[1];
                this.bCanEdit = canEdit;
                this.setPartName(this.myField);
                ConfigServiceHolder.setUser((String)("FieldDisplayViewData/" + this.subid), (String)(String.valueOf(this.myClass.getSimpleName()) + "." + this.myField));
                ConfigServiceHolder.setUser((String)("FieldDisplayViewCanEdit/" + this.subid), (boolean)canEdit);
            }
        }
    }

    private Class resolveName(String k) {
        String fqname;
        Class<?> ret = null;
        try {
            fqname = "ch.elexis.data." + k;
            ret = Class.forName(fqname);
        }
        catch (ClassNotFoundException ex) {
            ret = null;
        }
        if (ret == null) {
            try {
                fqname = "ch.elexis.core.data." + k;
                ret = Class.forName(fqname);
            }
            catch (ClassNotFoundException ex) {
                ret = null;
            }
        }
        if (ret == null) {
            SWTHelper.showError(Messages.FieldDisplayView_WrongTypeCaption, String.valueOf(Messages.FieldDisplayView_WrongTypeBody) + k + ")");
        }
        return ret;
    }

    private void makeActions() {
        this.newViewAction = new Action(Messages.FieldDisplayView_NewWindow){
            {
                this.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
                this.setToolTipText(Messages.FieldDisplayView_NewWindowToolTip);
            }

            public void run() {
                try {
                    String fieldtype = new SelectDataDialog().run();
                    FieldDisplayView n = (FieldDisplayView)FieldDisplayView.this.getViewSite().getPage().showView(FieldDisplayView.ID, StringTool.unique((String)"DataDisplay"), 2);
                    n.setField(fieldtype, false);
                    FieldDisplayView.this.heartbeat();
                }
                catch (PartInitException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        };
        this.editDataAction = new Action(Messages.FieldDisplayView_DataTypeAction){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.FieldDisplayView_DataTypeToolTip);
            }

            public void run() {
                SelectDataDialog sdd = new SelectDataDialog();
                if (sdd.open() == 0) {
                    FieldDisplayView.this.setField(sdd.result, sdd.bEditable);
                    FieldDisplayView.this.heartbeat();
                }
            }
        };
    }

    class SelectDataDialog
    extends TitleAreaDialog {
        private final String DATATYPE;
        String[] nodes;
        Combo cbNodes;
        Button btEditable;
        String result;
        boolean bEditable;

        SelectDataDialog() {
            super(FieldDisplayView.this.getViewSite().getShell());
            this.DATATYPE = Messages.FieldDisplayView_DataType;
        }

        String run() {
            this.create();
            if (this.nodes.length > 1 && this.open() == 0) {
                return this.result;
            }
            return this.nodes[0];
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayout((Layout)new GridLayout());
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.cbNodes = new Combo(ret, 4);
            this.cbNodes.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.nodes = CoreHub.localCfg.get(FieldDisplayView.this.NODE, "Patient.Diagnosen").split(",");
            this.cbNodes.setItems(this.nodes);
            this.btEditable = new Button(ret, 32);
            this.btEditable.setText(Messages.FieldDisplayView_FieldCanBeChanged);
            return ret;
        }

        public void create() {
            super.create();
            this.setTitle(this.DATATYPE);
            this.setMessage(Messages.FieldDisplayView_EnterExpression, 1);
        }

        protected void okPressed() {
            String tx = this.cbNodes.getText();
            if (StringTool.getIndex((String[])this.nodes, (String)tx) == -1) {
                String tm = String.valueOf(StringTool.join((String[])this.nodes, (String)",")) + "," + tx;
                CoreHub.localCfg.set(FieldDisplayView.this.NODE, tm);
            }
            this.result = tx;
            this.bEditable = this.btEditable.getSelection();
            super.okPressed();
        }
    }
}

