/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.data.PersistentObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class TristateCheckbox
extends Button {
    private static final PersistentObject.TristateBoolean START_STATE = PersistentObject.TristateBoolean.UNDEF;
    private static final boolean START_FALSEFIRST = true;
    protected boolean falseFirst = true;

    public TristateCheckbox(Composite parent, int style) {
        super(parent, style | 0x20);
        this.addSelectionListener(new TristateSelectionListener(false));
        this.setTristate(START_STATE);
        this.setCyclingOrder(true);
    }

    public TristateCheckbox(Composite parent, int style, boolean falseFirst) {
        super(parent, style | 0x20);
        this.addSelectionListener(new TristateSelectionListener(false));
        this.setTristate(START_STATE);
        this.setCyclingOrder(falseFirst);
    }

    public PersistentObject.TristateBoolean getTristate() {
        this.checkWidget();
        boolean selection = this.getSelection();
        boolean grayed = this.getGrayed();
        if (selection) {
            if (grayed) {
                return PersistentObject.TristateBoolean.UNDEF;
            }
            return PersistentObject.TristateBoolean.TRUE;
        }
        return PersistentObject.TristateBoolean.FALSE;
    }

    public String getTristateDbValue() {
        this.checkWidget();
        boolean selection = this.getSelection();
        boolean grayed = this.getGrayed();
        if (selection) {
            if (grayed) {
                return "";
            }
            return "1";
        }
        return "0";
    }

    public void setTristate(PersistentObject.TristateBoolean newState) {
        this.checkWidget();
        if (newState == PersistentObject.TristateBoolean.TRUE) {
            this.setSelection(true);
            this.setGrayed(false);
        } else if (newState == PersistentObject.TristateBoolean.FALSE) {
            this.setSelection(false);
            this.setGrayed(false);
        } else if (newState == PersistentObject.TristateBoolean.UNDEF) {
            this.setSelection(true);
            this.setGrayed(true);
        }
    }

    public void setTristateDbValue(String newState) {
        this.checkWidget();
        if (newState.equalsIgnoreCase("1")) {
            this.setSelection(true);
            this.setGrayed(false);
        } else if (newState.equalsIgnoreCase("0")) {
            this.setSelection(false);
            this.setGrayed(false);
        } else {
            this.setSelection(true);
            this.setGrayed(true);
        }
    }

    public void setCyclingOrder(boolean falseFirst) {
        this.falseFirst = falseFirst;
    }

    protected void checkSubclass() {
    }

    public class TristateSelectionListener
    implements SelectionListener {
        boolean falseFirst = true;

        TristateSelectionListener(boolean falseFirst) {
            this.falseFirst = falseFirst;
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.getSource();
            boolean selection = !button.getSelection();
            boolean grayed = button.getGrayed();
            if (this.falseFirst) {
                if (selection) {
                    if (grayed) {
                        button.setSelection(false);
                        button.setGrayed(false);
                    } else {
                        button.setSelection(true);
                        button.setGrayed(true);
                    }
                } else {
                    button.setSelection(true);
                    button.setGrayed(false);
                }
            } else if (selection) {
                if (grayed) {
                    button.setSelection(true);
                    button.setGrayed(false);
                } else {
                    button.setSelection(false);
                    button.setGrayed(false);
                }
            } else {
                button.setSelection(true);
                button.setGrayed(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

