/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.data.service.StoreToStringServiceHolder;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

public class GenericObjectDragSource
implements DragSourceListener {
    ISelectionRenderer renderer;
    Control dragSource;
    Transfer myTransfer = TextTransfer.getInstance();

    public GenericObjectDragSource(final StructuredViewer viewer) {
        this.dragSource = viewer.getControl();
        this.renderer = new ISelectionRenderer(){

            @Override
            public List<Object> getSelection() {
                if (viewer != null && viewer.getStructuredSelection() != null) {
                    return viewer.getStructuredSelection().toList();
                }
                return Collections.emptyList();
            }
        };
        this.setup();
    }

    public GenericObjectDragSource(StructuredViewer viewer, ISelectionRenderer iSelectionRenderer) {
        this.dragSource = viewer.getControl();
        this.renderer = iSelectionRenderer;
        this.setup();
    }

    public GenericObjectDragSource(Control control, ISelectionRenderer iSelectionRenderer) {
        this.dragSource = control;
        this.renderer = iSelectionRenderer;
        this.setup();
    }

    private void setup() {
        DragSource mine = new DragSource(this.dragSource, 1);
        mine.setTransfer(new Transfer[]{this.myTransfer});
        mine.addDragListener((DragSourceListener)this);
    }

    public void dragFinished(DragSourceEvent event) {
    }

    public void dragSetData(DragSourceEvent event) {
        StringBuilder sb = new StringBuilder();
        for (Object selected : this.renderer.getSelection()) {
            String string = StoreToStringServiceHolder.getStoreToString((Object)selected);
            sb.append(string).append(",");
        }
        event.data = sb.toString().replace(",$", "");
    }

    public void dragStart(DragSourceEvent event) {
        List<Object> selection = this.renderer.getSelection();
        event.doit = selection == null || selection.isEmpty() ? false : this.isDrag(selection);
    }

    protected boolean isDrag(List<Object> selection) {
        return true;
    }

    public static interface ISelectionRenderer {
        public List<Object> getSelection();
    }
}

