/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.startup;

import ch.elexis.core.ui.services.LocalDocumentServiceHolder;
import ch.elexis.core.ui.startup.Messages;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=org/eclipse/e4/ui/LifeCycle/appStartupComplete"})
public class StartupHandler
implements EventHandler {
    private static IEclipseContext applicationContext;

    public void handleEvent(Event event) {
        LoggerFactory.getLogger(this.getClass()).info("APPLICATION STARTUP COMPLETE");
        Object property = event.getProperty("org.eclipse.e4.data");
        if (property instanceof MApplication) {
            MApplication application = (MApplication)property;
            applicationContext = application.getContext();
        }
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                if (LocalDocumentServiceHolder.getService() != null && LocalDocumentServiceHolder.getService().isPresent() && !LocalDocumentServiceHolder.getService().get().getAll().isEmpty()) {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command command = commandService.getCommand("ch.elexis.core.ui.command.openLocalDocuments");
                    ExecutionEvent event = new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)this, null);
                    try {
                        command.executeWithChecks(event);
                        return LocalDocumentServiceHolder.getService().get().getAll().isEmpty();
                    }
                    catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.UiStartup_errortitle, (String)Messages.UiStartup_errormessage);
                    }
                }
                if (applicationContext != null && applicationContext.get(EPartService.class) != null) {
                    EPartService partService = (EPartService)applicationContext.get(EPartService.class);
                    try {
                        Collection dirtyParts = partService.getDirtyParts();
                        if (!dirtyParts.isEmpty()) {
                            for (MPart mPart : dirtyParts) {
                                if (mPart.getObject() != null || !mPart.getContributionURI().endsWith("internal.e4.compatibility.CompatibilityView")) continue;
                                mPart.setDirty(false);
                            }
                        }
                    }
                    catch (IllegalStateException e) {
                        LoggerFactory.getLogger(this.getClass()).warn("Exception resetting dirty state", (Throwable)e);
                    }
                }
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
    }
}

