/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.proposals;

import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.proposals.IdentifiableContentProposal;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class IdentifiableProposalProvider<T extends Identifiable>
implements IContentProposalProvider {
    private List<IdentifiableContentProposal<T>> proposals = new LinkedList<IdentifiableContentProposal<T>>();
    private IQuery<T> query;
    private List<T> queryResults = new LinkedList<T>();

    public IdentifiableProposalProvider(IQuery<T> query) {
        this.query = query;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (contents == null || contents.length() < 1) {
            return null;
        }
        if (position == 1) {
            this.queryResults.clear();
            this.queryResults = this.query.execute();
        }
        this.proposals.clear();
        for (Identifiable a : this.queryResults) {
            String label = this.getLabelForObject(a);
            if (!label.toLowerCase().startsWith(contents.toLowerCase())) continue;
            this.proposals.add(new IdentifiableContentProposal<Identifiable>(label, a));
        }
        return (IContentProposal[])this.proposals.toArray(new ContentProposal[0]);
    }

    public String getLabelForObject(T a) {
        return a.getLabel();
    }
}

