/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.StockCommissioningServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Query;
import ch.elexis.data.Stock;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ListDialog;

public class StockManagementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private DataBindingContext m_bindingContext;
    private Table tableStocks;
    private Text txtCode;
    private Text txtDescription;
    private Text txtLocation;
    private Text txtPrio;
    private Label lblOwnerText;
    private Label lblResponsibleText;
    private Button btnChkStoreInvalidNumbers;
    private Button btnIgnoreOrderedArticlesOnNextOrder;
    private WritableValue<Stock> stockDetail = new WritableValue(null, Stock.class);
    private TableViewer tableViewer;
    private Text txtMachineConfig;
    private Label lblMachineuuid;
    private Label lblDefaultArticleProvider;
    private Button btnMachineOutlayPartialPackages;
    private Button btnStoreBelow;
    private Button btnStoreAtMin;

    public StockManagementPreferencePage() {
        this.setTitle(Messages.LagerverwaltungPrefs_storageManagement);
    }

    public Control createContents(Composite parent) {
        Kontakt load;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(container, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        group.setText(Messages.StockManagementPreferencePage_group_text);
        Composite composite = new Composite((Composite)group, 0);
        GridData gd_composite = new GridData(4, 4, true, true, 1, 1);
        gd_composite.heightHint = 150;
        composite.setLayoutData((Object)gd_composite);
        TableColumnLayout tcl_composite = new TableColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        this.tableViewer = new TableViewer(composite, 67584);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Stock s1 = (Stock)e1;
                int s1I = s1.getPriority() != null ? s1.getPriority() : Integer.MAX_VALUE;
                Stock s2 = (Stock)e2;
                int s2I = s2.getPriority() != null ? s2.getPriority() : Integer.MAX_VALUE;
                return Integer.compare(s1I, s2I);
            }
        });
        this.tableViewer.addSelectionChangedListener(e -> {
            StructuredSelection ss = (StructuredSelection)e.getSelection();
            if (ss.isEmpty()) {
                this.stockDetail.setValue(null);
            } else {
                this.stockDetail.setValue((Object)((Stock)ss.getFirstElement()));
            }
        });
        this.tableStocks = this.tableViewer.getTable();
        this.tableStocks.setHeaderVisible(true);
        this.tableStocks.setLinesVisible(true);
        Menu menu = new Menu((Control)this.tableStocks);
        this.tableStocks.setMenu(menu);
        MenuItem mntmAddStock = new MenuItem(menu, 0);
        mntmAddStock.setText(Messages.StockManagementPreferencePage_mntmNewItem_text);
        mntmAddStock.setImage(Images.IMG_NEW.getImage());
        mntmAddStock.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Stock stock = new Stock("", Integer.MAX_VALUE);
                StockManagementPreferencePage.this.tableViewer.add((Object)stock);
                StockManagementPreferencePage.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)stock));
            }
        });
        MenuItem mntmRemoveStock = new MenuItem(menu, 0);
        mntmRemoveStock.setText(Messages.StockManagementPreferencePage_mntmNewItem_text_1);
        mntmRemoveStock.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean ret;
                Stock stock = (Stock)StockManagementPreferencePage.this.stockDetail.getValue();
                if (stock != null && (ret = MessageDialog.openQuestion((Shell)UiDesk.getTopShell(), (String)"Lager l\u00f6schen", (String)"Das L\u00f6schen dieses Lagers l\u00f6scht alle darauf verzeichneten Lagerbest\u00e4nde. Sind Sie sicher?"))) {
                    stock.removeFromDatabase();
                    StockManagementPreferencePage.this.tableViewer.remove((Object)stock);
                }
            }
        });
        TableViewerColumn tvcPriority = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmPriority = tvcPriority.getColumn();
        tcl_composite.setColumnData((Widget)tblclmPriority, (ColumnLayoutData)new ColumnPixelData(30, true, true));
        tblclmPriority.setText(Messages.StockManagementPreferencePage_tblclmnNewColumn_text);
        tvcPriority.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Stock s = (Stock)cell.getElement();
                if (s == null) {
                    return;
                }
                cell.setText(Integer.toString(s.getPriority()));
            }
        });
        TableViewerColumn tvcCode = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnCode = tvcCode.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnCode, (ColumnLayoutData)new ColumnPixelData(40));
        tblclmnCode.setText(Messages.StockManagementPreferencePage_tblclmnNewColumn_text_1);
        tvcCode.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Stock s = (Stock)cell.getElement();
                if (s == null) {
                    return;
                }
                cell.setText(s.getCode());
            }
        });
        TableViewerColumn tvcDescription = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnDescription = tvcDescription.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnDescription, (ColumnLayoutData)new ColumnWeightData(50));
        tblclmnDescription.setText(Messages.StockManagementPreferencePage_tblclmnNewColumn_text_3);
        tvcDescription.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Stock s = (Stock)cell.getElement();
                if (s == null) {
                    return;
                }
                cell.setText(s.getDescription());
            }
        });
        TableViewerColumn tvcOwner = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnOwner = tvcOwner.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnOwner, (ColumnLayoutData)new ColumnWeightData(40));
        tblclmnOwner.setText(Messages.StockManagementPreferencePage_tblclmnNewColumn_text_2);
        tvcOwner.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Mandant owner;
                Stock s = (Stock)cell.getElement();
                if (s != null && (owner = s.getOwner()) != null) {
                    cell.setText(owner.getLabel());
                }
            }
        });
        Composite compositeDetail = new Composite((Composite)group, 0);
        compositeDetail.setLayout((Layout)new GridLayout(4, false));
        compositeDetail.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        Label lblPrio = new Label(compositeDetail, 0);
        lblPrio.setText(Messages.StockManagementPreferencePage_lblPrio_text);
        this.txtPrio = new Text(compositeDetail, 2048);
        GridData gd_txtPrio = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtPrio.widthHint = 150;
        this.txtPrio.setLayoutData((Object)gd_txtPrio);
        Label lblCode = new Label(compositeDetail, 0);
        lblCode.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCode.setToolTipText(Messages.StockManagementPreferencePage_lblCode_toolTipText);
        lblCode.setText(Messages.StockManagementPreferencePage_lblCode_text);
        this.txtCode = new Text(compositeDetail, 2048);
        GridData gd_txtCode = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtCode.widthHint = 100;
        this.txtCode.setLayoutData((Object)gd_txtCode);
        this.txtCode.setTextLimit(3);
        Label lblDescription = new Label(compositeDetail, 0);
        lblDescription.setText(Messages.StockManagementPreferencePage_lblDescription_text);
        this.txtDescription = new Text(compositeDetail, 2048);
        this.txtDescription.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblLocation = new Label(compositeDetail, 0);
        lblLocation.setToolTipText(Messages.StockManagementPreferencePage_lblLocation_toolTipText);
        lblLocation.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLocation.setText(Messages.StockManagementPreferencePage_lblLocation_text);
        this.txtLocation = new Text(compositeDetail, 2048);
        this.txtLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Link lblOwner = new Link(compositeDetail, 0);
        lblOwner.setToolTipText(Messages.StockManagementPreferencePage_lblOwner_toolTipText);
        lblOwner.setText(Messages.StockManagementPreferencePage_lblOwner_text);
        lblOwner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Stock s = (Stock)StockManagementPreferencePage.this.stockDetail.getValue();
                if (s == null) {
                    return;
                }
                KontaktSelektor ks = new KontaktSelektor(UiDesk.getTopShell(), Mandant.class, "Mandant ausw\u00e4hlen", "Bitte selektieren Sie den Eigent\u00fcmer", new String[0]);
                int ret = ks.open();
                if (ret == 0) {
                    Mandant p = (Mandant)ks.getSelection();
                    s.setOwner(p);
                    String label = p != null ? p.getLabel() : "";
                    StockManagementPreferencePage.this.lblOwnerText.setText(label);
                } else {
                    s.setOwner(null);
                    StockManagementPreferencePage.this.lblOwnerText.setText("");
                }
                StockManagementPreferencePage.this.tableViewer.update((Object)s, null);
            }
        });
        this.lblOwnerText = new Label(compositeDetail, 0);
        this.lblOwnerText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Link lblResponsible = new Link(compositeDetail, 0);
        lblResponsible.setToolTipText(Messages.StockManagementPreferencePage_lblResponsible_toolTipText);
        lblResponsible.setText(Messages.StockManagementPreferencePage_lblResonsible_text);
        lblResponsible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Stock s = (Stock)StockManagementPreferencePage.this.stockDetail.getValue();
                if (s == null) {
                    return;
                }
                KontaktSelektor ks = new KontaktSelektor(UiDesk.getTopShell(), Kontakt.class, "Lagerverantwortlichen ausw\u00e4hlen", "Bitte selektieren Sie den Lagerverantwortlichen", new String[0]);
                int ret = ks.open();
                if (ret == 0) {
                    Kontakt p = (Kontakt)ks.getSelection();
                    s.setResponsible(p);
                    String label = p != null ? p.getLabel() : "";
                    StockManagementPreferencePage.this.lblResponsibleText.setText(label);
                } else {
                    s.setResponsible(null);
                    StockManagementPreferencePage.this.lblResponsibleText.setText("");
                }
            }
        });
        this.lblResponsibleText = new Label(compositeDetail, 0);
        this.lblResponsibleText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label lblNewLabel = new Label(compositeDetail, 258);
        lblNewLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        lblNewLabel.setText(Messages.StockManagementPreferencePage_lblNewLabel_text);
        Link lblMachine = new Link(compositeDetail, 0);
        lblMachine.setToolTipText(Messages.StockManagementPreferencePage_lblMachine_toolTipText);
        lblMachine.setText(Messages.StockManagementPreferencePage_lblMachine_text);
        lblMachine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Stock s = (Stock)StockManagementPreferencePage.this.stockDetail.getValue();
                if (s == null) {
                    return;
                }
                List allDrivers = StockCommissioningServiceHolder.get().listAllAvailableDrivers();
                if (allDrivers.size() == 0) {
                    MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)"No drivers found", (String)"There are no stock commissioning system drivers available.");
                    return;
                }
                ListDialog ld = new ListDialog(UiDesk.getTopShell());
                ld.setTitle("Driver selection");
                ld.setMessage("Please select a commissioning system driver");
                ld.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                ld.setAddCancelButton(true);
                ld.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return StockCommissioningServiceHolder.get().getInfoStringForDriver((UUID)element, true);
                    }
                });
                ld.setInput((Object)allDrivers);
                ld.setWidthInChars(80);
                ld.setHeightInChars(5);
                int retVal = ld.open();
                UUID ics = null;
                if (retVal == 0) {
                    Object[] result = ld.getResult();
                    if (result.length > 0) {
                        ics = (UUID)result[0];
                    }
                } else if (1 == retVal) {
                    ics = null;
                }
                if (ics != null) {
                    s.setDriverUuid(ics.toString());
                    StockManagementPreferencePage.this.lblMachineuuid.setText(StockCommissioningServiceHolder.get().getInfoStringForDriver(ics, false));
                } else {
                    s.setDriverUuid(null);
                    StockManagementPreferencePage.this.lblMachineuuid.setText("");
                }
            }
        });
        this.lblMachineuuid = new Label(compositeDetail, 0);
        this.lblMachineuuid.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label lblMachineConfig = new Label(compositeDetail, 0);
        lblMachineConfig.setText(Messages.StockManagementPreferencePage_lblMachineConfig_text);
        this.txtMachineConfig = new Text(compositeDetail, 2048);
        this.txtMachineConfig.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.btnMachineOutlayPartialPackages = new Button(compositeDetail, 32);
        this.btnMachineOutlayPartialPackages.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.btnMachineOutlayPartialPackages.setText(Messages.StockManagementPreferencePage_btnMachineOutlayPartialPackages_text);
        boolean outlayPartialPackages = ConfigServiceHolder.getGlobal((String)"inventory/machineOutlayPartialPackages", (boolean)false);
        this.btnMachineOutlayPartialPackages.setSelection(outlayPartialPackages);
        this.btnIgnoreOrderedArticlesOnNextOrder = new Button(container, 32);
        this.btnIgnoreOrderedArticlesOnNextOrder.setText(Messages.LagerverwaltungPrefs_ignoreOrderedArticleOnNextOrder);
        this.btnIgnoreOrderedArticlesOnNextOrder.setSelection(this.getPreferenceStore().getBoolean("inventory/order_exclude_already_ordered_items"));
        this.btnChkStoreInvalidNumbers = new Button(container, 32);
        this.btnChkStoreInvalidNumbers.setText(Messages.LagerverwaltungPrefs_checkForInvalid);
        this.btnChkStoreInvalidNumbers.setSelection(this.getPreferenceStore().getBoolean("inventory/check_values"));
        Group group1 = new Group(container, 4);
        group1.setText(Messages.LagerverwaltungPrefs_orderCriteria);
        group1.setLayout((Layout)new RowLayout(512));
        this.btnStoreBelow = new Button((Composite)group1, 16);
        this.btnStoreBelow.setText(Messages.LagerverwaltungPrefs_orderWhenBelowMi);
        this.btnStoreAtMin = new Button((Composite)group1, 16);
        this.btnStoreAtMin.setText(Messages.LagerverwaltungPrefs_orderWhenAtMin);
        int valInventoryOrderTrigger = ConfigServiceHolder.getGlobal((String)"inventory/order_trigger", (int)0);
        boolean isInventoryOrderEqualValue = 1 == valInventoryOrderTrigger;
        this.btnStoreAtMin.setSelection(isInventoryOrderEqualValue);
        this.btnStoreBelow.setSelection(!isInventoryOrderEqualValue);
        Composite compDefaultProvider = new Composite(container, 0);
        compDefaultProvider.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_compDefaultProvider = new GridLayout(3, false);
        gl_compDefaultProvider.marginWidth = 0;
        gl_compDefaultProvider.marginHeight = 0;
        compDefaultProvider.setLayout((Layout)gl_compDefaultProvider);
        Link linkDefaultArticleProvider = new Link(compDefaultProvider, 0);
        linkDefaultArticleProvider.setToolTipText(Messages.StockManagementPreferencePage_linkDefaultArticleProvider_toolTipText);
        linkDefaultArticleProvider.setText(Messages.StockManagementPreferencePage_linkDefaultArticleProvider_text);
        linkDefaultArticleProvider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktSelektor ks = new KontaktSelektor(UiDesk.getTopShell(), Kontakt.class, "Standard-Lieferant ausw\u00e4hlen", "Bitte selektieren Sie den Standard-Lieferanten", new String[0]);
                int ret = ks.open();
                if (ret == 0) {
                    Kontakt p = (Kontakt)ks.getSelection();
                    if (p != null) {
                        ConfigServiceHolder.setGlobal((String)"inventory/defaultArticleProvider", (String)p.getId());
                        StockManagementPreferencePage.this.lblDefaultArticleProvider.setText(p.getLabel());
                    }
                } else {
                    ConfigServiceHolder.setGlobal((String)"inventory/defaultArticleProvider", null);
                    StockManagementPreferencePage.this.lblDefaultArticleProvider.setText("");
                }
            }
        });
        this.lblDefaultArticleProvider = new Label(compDefaultProvider, 0);
        this.lblDefaultArticleProvider.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        String id = ConfigServiceHolder.getGlobal((String)"inventory/defaultArticleProvider", null);
        this.lblDefaultArticleProvider.setText("");
        new Label(compDefaultProvider, 0);
        if (id != null && (load = Kontakt.load((String)id)).exists()) {
            this.lblDefaultArticleProvider.setText(load.getLabel());
        }
        this.tableViewer.setInput((Object)new Query(Stock.class).execute());
        this.m_bindingContext = this.initDataBindings();
        this.stockDetail.addChangeListener(e -> {
            Stock stock = (Stock)this.stockDetail.getValue();
            if (stock != null) {
                Mandant owner = stock.getOwner();
                if (owner != null) {
                    this.lblOwnerText.setText(owner.getLabel());
                } else {
                    this.lblOwnerText.setText("");
                }
                Kontakt responsible = stock.getResponsible();
                if (responsible != null) {
                    this.lblResponsibleText.setText(responsible.getLabel());
                } else {
                    this.lblResponsibleText.setText("");
                }
                String machineUuid = stock.getDriverUuid();
                if (machineUuid != null && !machineUuid.isEmpty()) {
                    String info = StockCommissioningServiceHolder.get().getInfoStringForDriver(UUID.fromString(machineUuid), false);
                    this.lblMachineuuid.setText(info);
                } else {
                    this.lblMachineuuid.setText("");
                }
            } else {
                this.lblOwnerText.setText("");
                this.lblResponsibleText.setText("");
            }
        });
        return container;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL));
        this.getPreferenceStore().setDefault("inventory/check_values", true);
        this.getPreferenceStore().setDefault("inventory/order_exclude_already_ordered_items", false);
    }

    protected void performApply() {
        this.tableViewer.setInput((Object)new Query(Stock.class).execute());
        this.setErrorMessage(null);
        super.performApply();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("inventory/check_values", this.btnChkStoreInvalidNumbers.getSelection());
        this.getPreferenceStore().setValue("inventory/order_exclude_already_ordered_items", this.btnIgnoreOrderedArticlesOnNextOrder.getSelection());
        this.getPreferenceStore().setValue("inventory/machineOutlayPartialPackages", this.btnMachineOutlayPartialPackages.getSelection());
        this.getPreferenceStore().setValue("inventory/order_trigger", this.btnStoreBelow.getSelection() ? 0 : 1);
        return super.performOk();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTxtCodeObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtCode);
        IObservableValue stockDetailCodeObserveDetailValue = PojoProperties.value(Stock.class, (String)"code", String.class).observeDetail(this.stockDetail);
        bindingContext.bindValue((IObservableValue)observeTextTxtCodeObserveWidget, stockDetailCodeObserveDetailValue, null, null);
        ISWTObservableValue observeTextTxtDescriptionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtDescription);
        IObservableValue stockDetailDescriptionObserveDetailValue = PojoProperties.value(Stock.class, (String)"description", String.class).observeDetail(this.stockDetail);
        bindingContext.bindValue((IObservableValue)observeTextTxtDescriptionObserveWidget, stockDetailDescriptionObserveDetailValue, null, null);
        ISWTObservableValue observeTextTxtLocationObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtLocation);
        IObservableValue stockDetailLocationObserveDetailValue = PojoProperties.value(Stock.class, (String)"location", String.class).observeDetail(this.stockDetail);
        bindingContext.bindValue((IObservableValue)observeTextTxtLocationObserveWidget, stockDetailLocationObserveDetailValue, null, null);
        ISWTObservableValue observeTextTxtPrioObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPrio);
        IObservableValue stockDetailGlobalPreferenceObserveDetailValue = PojoProperties.value(Stock.class, (String)"priority", Integer.class).observeDetail(this.stockDetail);
        bindingContext.bindValue((IObservableValue)observeTextTxtPrioObserveWidget, stockDetailGlobalPreferenceObserveDetailValue, null, null);
        ISWTObservableValue observeTextTxtMachineConfigObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtMachineConfig);
        IObservableValue stockDetailMachineConfigObserveDetailValue = PojoProperties.value(Stock.class, (String)"driverConfig", String.class).observeDetail(this.stockDetail);
        bindingContext.bindValue((IObservableValue)observeTextTxtMachineConfigObserveWidget, stockDetailMachineConfigObserveDetailValue, null, null);
        return bindingContext;
    }
}

