/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.data.interfaces.ILabItem;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.data.interfaces.IXid;
import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.data.Artikel;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.Labor;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Xid;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.XMLTool;
import java.util.LinkedList;
import java.util.List;

public class XidElement
extends XChangeElement {
    public static final String XMLNAME = "xid";
    public static final String ELEMENT_IDENTITY = "identity";
    public static final String ATTR_IDENTITY_DOMAIN = "domain";
    public static final String ATTR_IDENTITY_DOMAIN_ID = "domainID";
    public static final String ATTR_IDENTITY_QUALITY = "quality";
    public static final String ATTR_ISGUID = "isGUID";
    public static final String[] IDENTITY_QUALITIES = new String[]{"unknownAssignment", "localAssignment", "regionalAssignment", "globalAssignment"};

    @Override
    public String getXMLName() {
        return XMLNAME;
    }

    public static boolean isUUID(IXid xid) {
        return (xid.getQuality() & 4) != 0;
    }

    public static int getPureQuality(IXid xid) {
        return xid.getQuality() & 3;
    }

    public XidElement asExporter(XChangeExporter home, IVerrechenbar iv) {
        this.asExporter(home);
        if (iv instanceof PersistentObject) {
            PersistentObject po = (PersistentObject)iv;
            this.setAttribute("id", XMLTool.idToXMLID((String)po.getId()));
            this.addIdentities(po, iv.getXidDomain(), po.getId(), 1, true);
        }
        return this;
    }

    public XidElement asExporter(XChangeExporter home, ILabItem li) {
        this.asExporter(home);
        this.setAttribute("id", XMLTool.idToXMLID((String)li.getId()));
        StringBuilder domainRoot = new StringBuilder("www.xid.ch/labitems/");
        Labor lab = ((LabItem)li).getLabor();
        if (lab == null || !lab.isValid()) {
            domainRoot.append("unknown");
        } else {
            domainRoot.append(lab.get("Bezeichnung1"));
        }
        String domain = domainRoot.toString();
        Xid.localRegisterXIDDomainIfNotExists((String)domain, (String)li.getLabel(), (int)1);
        this.addIdentities((PersistentObject)((LabItem)li), domain, li.getName(), 1, true);
        return this;
    }

    public XidElement asExporter(XChangeExporter home, Artikel art) {
        String pk;
        this.asExporter(home);
        this.setAttribute("id", XMLTool.idToXMLID((String)art.getId()));
        String ean = art.getEAN();
        if (!StringTool.isNothing((Object)ean)) {
            this.addIdentities((PersistentObject)art, "www.xid.ch/id/ean", ean, 2, false);
        }
        if (!StringTool.isNothing((Object)(pk = art.getPharmaCode()))) {
            this.addIdentities((PersistentObject)art, "www.xid.ch/id/pharmacode/ch", pk, 2, false);
        }
        return this;
    }

    public XidElement asExporter(XChangeExporter home, Kontakt k) {
        this.asExporter(home);
        IXid best = k.getXid();
        String id = XMLTool.idToXMLID((String)k.getId());
        if ((best.getQuality() & 7) >= 4) {
            id = XMLTool.idToXMLID((String)best.getDomainId());
        } else {
            k.addXid("www.elexis.ch/xid", id, true);
        }
        this.setAttribute("id", XMLTool.idToXMLID((String)k.getId()));
        List xids = k.getXids();
        for (IXid xid : xids) {
            int val = xid.getQuality();
            int v1 = val & 3;
            Identity ident = new Identity().asExporter(home, xid.getDomain(), xid.getDomainId(), v1, XidElement.isUUID(xid));
            this.add(ident);
        }
        return this;
    }

    public XidElement asExporter(XChangeExporter home, Fall fall) {
        this.asExporter(home);
        IXid best = fall.getXid();
        String id = XMLTool.idToXMLID((String)fall.getId());
        if ((best.getQuality() & 7) >= 4) {
            id = XMLTool.idToXMLID((String)best.getDomainId());
        } else {
            fall.addXid("www.elexis.ch/xid", id, true);
        }
        this.setAttribute("id", XMLTool.idToXMLID((String)fall.getId()));
        List xids = fall.getXids();
        for (IXid xid : xids) {
            int val = xid.getQuality();
            int v1 = val & 3;
            Identity ident = new Identity().asExporter(home, xid.getDomain(), xid.getDomainId(), v1, XidElement.isUUID(xid));
            this.add(ident);
        }
        return this;
    }

    private void addIdentities(PersistentObject po, String domain, String domid, int q, boolean bGuid) {
        List xids = po.getXids();
        boolean bDomain = false;
        for (IXid xid : xids) {
            if (xid.getDomain().equals(domain)) {
                bDomain = true;
            }
            Identity ident = new Identity().asExporter(this.sender, xid.getDomain(), xid.getDomainId(), XidElement.getPureQuality(xid), XidElement.isUUID(xid));
            this.add(ident);
        }
        if (!bDomain) {
            po.addXid(domain, domid, false);
            Identity ident = new Identity().asExporter(this.sender, domain, domid, q, bGuid);
            this.add(ident);
        }
    }

    public void addIdentity(String domain, String domainID, int quality, boolean isGuid) {
        this.add(new Identity().asExporter(this.sender, domain, domainID, quality, isGuid));
    }

    public List<Identity> getIdentities() {
        return this.getChildren(ELEMENT_IDENTITY, Identity.class);
    }

    public void setMainID(String domain) {
        Identity best = null;
        for (Identity cand : this.getIdentities()) {
            if (domain != null) {
                if (!cand.getAttr(ATTR_IDENTITY_DOMAIN).equalsIgnoreCase(domain)) continue;
                best = cand;
                break;
            }
            if (best == null) {
                best = cand;
                continue;
            }
            if (best.isGuid()) {
                if (!cand.isGuid() || cand.getQuality() <= best.getQuality()) continue;
                best = cand;
                continue;
            }
            if (cand.isGuid()) {
                best = cand;
                continue;
            }
            if (cand.getQuality() <= best.getQuality()) continue;
            best = cand;
        }
        if (best == null || !best.isGuid()) {
            best = new Identity().asExporter(this.sender, "www.elexis.ch/xid", StringTool.unique((String)"xidID"), 1, true);
            this.add(best);
        }
        this.setAttribute("id", XMLTool.idToXMLID((String)best.getAttr(ATTR_IDENTITY_DOMAIN_ID)));
    }

    public XIDMATCH match(PersistentObject po) {
        if (po.getId().equals(this.getAttr("id"))) {
            return XIDMATCH.SURE;
        }
        int sure = 0;
        List poXids = po.getXids();
        List<? extends XChangeElement> idents = this.getChildren(ELEMENT_IDENTITY, Identity.class);
        for (IXid xid : poXids) {
            String domain = xid.getDomain();
            String domid = xid.getDomainId();
            for (Identity identity : idents) {
                if (!identity.getAttr(ATTR_IDENTITY_DOMAIN).equals(domain) || !identity.getAttr(ATTR_IDENTITY_DOMAIN_ID).equals(domid)) continue;
                if (XidElement.isUUID(xid)) {
                    return XIDMATCH.SURE;
                }
                if (xid.getQuality() <= 1) continue;
                ++sure;
            }
        }
        switch (sure) {
            case 0: {
                return XIDMATCH.NONE;
            }
            case 1: {
                return XIDMATCH.POSSIBLE;
            }
        }
        return XIDMATCH.SURE;
    }

    public List<IPersistentObject> findObject() {
        List<? extends XChangeElement> idents = this.getChildren(ELEMENT_IDENTITY, Identity.class);
        LinkedList<IPersistentObject> candidates = new LinkedList<IPersistentObject>();
        boolean lastGuid = false;
        int lastQuality = 0;
        for (XChangeElement xChangeElement : idents) {
            String domain = xChangeElement.getAttr(ATTR_IDENTITY_DOMAIN);
            String domain_id = xChangeElement.getAttr(ATTR_IDENTITY_DOMAIN_ID);
            String quality = xChangeElement.getAttr(ATTR_IDENTITY_QUALITY);
            String isguid = xChangeElement.getAttr(ATTR_ISGUID);
            IPersistentObject cand = Xid.findObject((String)domain, (String)domain_id);
            if (cand == null) continue;
            boolean actGuid = Boolean.parseBoolean(isguid);
            int actQuality = StringTool.getIndex((String[])IDENTITY_QUALITIES, (String)quality);
            if (candidates.contains(cand)) {
                if (lastGuid && !actGuid || actQuality < lastQuality) continue;
                candidates.remove(cand);
            }
            candidates.add(cand);
            lastQuality = actQuality;
            lastGuid = actGuid;
        }
        return candidates;
    }

    public static class Identity
    extends XChangeElement {
        @Override
        public String getXMLName() {
            return XidElement.ELEMENT_IDENTITY;
        }

        public Identity asExporter(XChangeExporter home, String domain, String domain_id, int quality, boolean isGuid) {
            this.asExporter(home);
            this.setAttribute(XidElement.ATTR_IDENTITY_DOMAIN, domain);
            this.setAttribute(XidElement.ATTR_IDENTITY_DOMAIN_ID, domain_id);
            this.setAttribute(XidElement.ATTR_IDENTITY_QUALITY, IDENTITY_QUALITIES[quality]);
            this.setAttribute(XidElement.ATTR_ISGUID, Boolean.toString(isGuid));
            return this;
        }

        public String getDomain() {
            return this.getAttr(XidElement.ATTR_IDENTITY_DOMAIN);
        }

        public String getDomainId() {
            return this.getAttr(XidElement.ATTR_IDENTITY_DOMAIN_ID);
        }

        public int getQuality() {
            String sq = this.getAttr(XidElement.ATTR_IDENTITY_QUALITY);
            int idx = StringTool.getIndex((String[])IDENTITY_QUALITIES, (String)sq);
            return idx > 0 ? idx : 0;
        }

        public boolean isGuid() {
            return Boolean.parseBoolean(this.getAttr(XidElement.ATTR_ISGUID));
        }
    }

    public static enum XIDMATCH {
        NONE,
        POSSIBLE,
        SURE;

    }
}

