/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.core.ui.exchange.elements.XidElement;
import ch.elexis.data.Artikel;
import ch.elexis.data.Prescription;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.XMLTool;
import org.apache.commons.lang3.StringUtils;

public class MedicationElement
extends XChangeElement {
    public static final String XMLNAME = "medication";
    public static final String ATTRIB_BEGINDATE = "startDate";
    public static final String ATTRIB_ENDDATE = "stopDate";
    public static final String ATTRIB_PRODUCT = "product";
    public static final String ATTRIB_DOSAGE = "dosage";
    public static final String ATTRIB_UNITS = "dosageUnit";
    public static final String ATTRIB_FREQUENCY = "frequency";
    public static final String ATTRIB_SUBSTANCE = "substance";
    public static final String ATTRIB_REMARK = "remark";
    public static final String ATTRIB_TYPE = "type";
    public static final String ELEMENT_XID = "xid";
    public static final String ELEMENT_META = "meta";

    @Override
    public String getXMLName() {
        return XMLNAME;
    }

    public MedicationElement asExporter(XChangeExporter parent, Prescription pr) {
        this.asExporter(parent);
        Artikel art = pr.getArtikel();
        String begin = pr.getBeginDate();
        String end = pr.getEndDate();
        String dose = pr.getDosis();
        String remark = pr.getBemerkung();
        this.setAttribute(ATTRIB_BEGINDATE, XMLTool.dateToXmlDate((String)begin));
        if (!StringTool.isNothing((Object)end)) {
            this.setAttribute(ATTRIB_ENDDATE, XMLTool.dateToXmlDate((String)end));
        }
        this.setAttribute(ATTRIB_FREQUENCY, dose);
        this.setAttribute(ATTRIB_PRODUCT, art.getLabel());
        this.setAttribute(ATTRIB_REMARK, remark);
        this.setAttribute(ATTRIB_TYPE, pr.getEntryType().name());
        this.add(new XidElement().asExporter(parent, art));
        parent.getContainer().addChoice(this, pr.getLabel(), (Object)pr);
        return this;
    }

    public String getFirstDate() {
        String begin = this.getAttr(ATTRIB_BEGINDATE);
        return new TimeTool(begin).toString(4);
    }

    public String getLastDate() {
        String last = this.getAttr(ATTRIB_ENDDATE);
        if (StringUtils.isBlank((CharSequence)last)) {
            return null;
        }
        return new TimeTool(last).toString(4);
    }

    public String getText() {
        return this.getAttr(ATTRIB_SUBSTANCE);
    }

    public String getDosage() {
        return this.getAttr(ATTRIB_FREQUENCY);
    }

    public String getSubstance() {
        return this.getAttr(ATTRIB_SUBSTANCE);
    }

    public String getRemark() {
        return this.getAttr(ATTRIB_REMARK);
    }

    public String getProduct() {
        return this.getAttr(ATTRIB_PRODUCT);
    }

    public String getGtin() {
        return this.getXid().getIdentities().stream().filter(i -> "www.xid.ch/id/ean".equalsIgnoreCase(i.getDomain())).findFirst().map(XidElement.Identity::getDomainId).orElse(null);
    }

    public String getPharmacode() {
        return this.getXid().getIdentities().stream().filter(i -> "www.xid.ch/id/pharmacode/ch".equalsIgnoreCase(i.getDomain())).findFirst().map(XidElement.Identity::getDomainId).orElse(null);
    }
}

