/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.eigenleistung;

import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.ICustomService;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.actions.ToggleVerrechenbarFavoriteAction;
import ch.elexis.core.ui.commands.EditEigenleistungUi;
import ch.elexis.core.ui.dialogs.EigenLeistungDialog;
import ch.elexis.core.ui.eigenleistung.Messages;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EigenleistungCodeSelectorFactory
extends CodeSelectorFactory {
    private ToggleVerrechenbarFavoriteAction tvfa = new ToggleVerrechenbarFavoriteAction();
    private ISelectionChangedListener selChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TableViewer tv = (TableViewer)event.getSource();
            StructuredSelection ss = (StructuredSelection)tv.getSelection();
            EigenleistungCodeSelectorFactory.this.tvfa.updateSelection(ss.isEmpty() ? null : ss.getFirstElement());
            if (!ss.isEmpty()) {
                ICustomService ea = (ICustomService)ss.getFirstElement();
                ContextServiceHolder.get().getRootContext().setNamed("ch.elexis.core.ui.eigenleistung.selection", (Object)ea);
            } else {
                ContextServiceHolder.get().getRootContext().setNamed("ch.elexis.core.ui.eigenleistung.selection", null);
            }
        }
    };

    @Override
    public ViewerConfigurer createViewerConfigurer(final CommonViewer commonViewer) {
        MenuManager menu = new MenuManager();
        menu.add((IAction)this.tvfa);
        menu.add((IAction)new Action(Messages.EigenleistungContextMenu_deleteAction){
            {
                super($anonymous0);
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.EigenleistungContextMenu_deleteActionToolTip);
            }

            public void run() {
                ICustomService act = ContextServiceHolder.get().getNamed("ch.elexis.core.ui.eigenleistung.selection").orElse(null);
                if (act != null && MessageDialog.openConfirm((Shell)commonViewer.getViewerWidget().getControl().getShell(), (String)Messages.EigenleistungContextMenu_deleteActionConfirmCaption, (String)MessageFormat.format(Messages.EigenleistungContextMenu_deleteConfirmBody, act.getText()))) {
                    CoreModelServiceHolder.get().delete((Deleteable)act);
                    commonViewer.getConfigurer().getControlFieldProvider().fireChangedEvent();
                    commonViewer.notify(CommonViewer.Message.update);
                }
            }

            public boolean isEnabled() {
                return ContextServiceHolder.get().getNamed("ch.elexis.core.ui.eigenleistung.selection").isPresent();
            }
        });
        menu.add((IAction)new Action(Messages.EigenleistungContextMenu_propertiesAction){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.EigenleistungContextMenu_propertiesTooltip);
            }

            public void run() {
                ICustomService act = ContextServiceHolder.get().getNamed("ch.elexis.core.ui.eigenleistung.selection").orElse(null);
                if (act != null) {
                    EditEigenleistungUi.executeWithParams(NoPoUtil.loadAsPersistentObject((Identifiable)act));
                }
            }

            public boolean isEnabled() {
                return ContextServiceHolder.get().getNamed("ch.elexis.core.ui.eigenleistung.selection").isPresent();
            }
        });
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] iContributionItemArray = manager.getItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    item.update();
                    ++n2;
                }
            }
        });
        commonViewer.setNamedSelection("ch.elexis.core.ui.eigenleistung.selection");
        commonViewer.setContextMenu(menu);
        commonViewer.setSelectionChangedListener(this.selChangeListener);
        FieldDescriptor[] fieldDescriptors = new FieldDescriptor[]{new FieldDescriptor("Code", "code", null), new FieldDescriptor("Bezeichnung", "description", null)};
        SelectorPanelProvider slp = new SelectorPanelProvider(fieldDescriptors, true);
        slp.addActions(new IAction[]{new Action("neu erstellen"){
            {
                super($anonymous0);
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(ch.elexis.core.ui.views.codesystems.Messages.BlockDetailDisplay_addSelfDefinedServices);
            }

            public void run() {
                Shell parent = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                EigenLeistungDialog dialog = new EigenLeistungDialog(parent, null);
                dialog.open();
                commonViewer.notify(CommonViewer.Message.update);
            }
        }});
        ViewerConfigurer vc = new ViewerConfigurer(new EigenleistungContentProvider(commonViewer, slp), new DefaultLabelProvider(), slp, new ViewerConfigurer.DefaultButtonProvider(), new SimpleWidgetProvider(3, 0, commonViewer));
        return vc.setContentType(ViewerConfigurer.ContentType.GENERICOBJECT);
    }

    @Override
    public Class<?> getElementClass() {
        return ICustomService.class;
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getCodeSystemName() {
        return "Eigenleistung";
    }

    private class EigenleistungContentProvider
    extends CommonViewerContentProvider {
        private ViewerConfigurer.ControlFieldProvider controlFieldProvider;

        public EigenleistungContentProvider(CommonViewer commonViewer, ViewerConfigurer.ControlFieldProvider controlFieldProvider) {
            super(commonViewer);
            this.controlFieldProvider = controlFieldProvider;
        }

        public Object[] getElements(Object inputElement) {
            IQuery<?> query = this.getBaseQuery();
            this.controlFieldProvider.setQuery(query);
            this.applyQueryFilters(query);
            query.orderBy("description", IQuery.ORDER.ASC);
            query.orderBy("code", IQuery.ORDER.ASC);
            List elements = query.execute();
            return elements.toArray(new Object[elements.size()]);
        }

        @Override
        protected IQuery<?> getBaseQuery() {
            IQuery query = CoreModelServiceHolder.get().getQuery(ICustomService.class);
            return query;
        }
    }
}

