/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.editors;

import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectiveEditingSupport
extends EditingSupport {
    private TextCellEditor editor;
    private final String field;
    private Logger log = LoggerFactory.getLogger(ReflectiveEditingSupport.class);
    private IModelService modelService;

    public ReflectiveEditingSupport(TableViewer columnViewer, String field) {
        this(columnViewer, field, null, false);
    }

    public ReflectiveEditingSupport(TableViewer columnViewer, String field, ICellEditorValidator validator, boolean markValidationFailed) {
        super((ColumnViewer)columnViewer);
        this.field = field;
        this.editor = new TextCellEditor((Composite)columnViewer.getTable());
        if (validator != null) {
            this.editor.setValidator(validator);
            if (markValidationFailed) {
                this.editor.addListener(new ICellEditorListener(){

                    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                        if (newValidState) {
                            ReflectiveEditingSupport.this.editor.getControl().setBackground(Display.getCurrent().getSystemColor(1));
                        } else {
                            ReflectiveEditingSupport.this.editor.getControl().setBackground(Display.getCurrent().getSystemColor(3));
                        }
                    }

                    public void cancelEditor() {
                        ReflectiveEditingSupport.this.editor.getControl().setBackground(Display.getCurrent().getSystemColor(1));
                    }

                    public void applyEditorValue() {
                        ReflectiveEditingSupport.this.editor.getControl().setBackground(Display.getCurrent().getSystemColor(1));
                    }
                });
            }
        }
    }

    public ReflectiveEditingSupport setModelService(IModelService modelService) {
        this.modelService = modelService;
        return this;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected boolean canEdit(Object element) {
        return !Objects.isNull(element) && !(element instanceof String);
    }

    protected Object getValue(Object element) {
        try {
            return BeanUtils.getProperty((Object)element, (String)this.field);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error getting property [" + this.field + "] of [" + element + "]", (Throwable)e);
            return null;
        }
    }

    protected void setValue(Object element, Object value) {
        if (this.canEdit(element)) {
            LockResponse lr = LocalLockServiceHolder.get().acquireLock(element);
            if (!lr.isOk()) {
                return;
            }
            try {
                BeanUtils.setProperty((Object)element, (String)this.field, (Object)value);
                if (this.modelService != null && element instanceof Identifiable) {
                    this.modelService.save((Identifiable)element);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error setting property [" + this.field + "] of [" + element + "]", (Throwable)e);
            }
            if (!(lr = LocalLockServiceHolder.get().releaseLock(element)).isOk()) {
                this.log.warn("Error releasing lock for [{}]: {}", element, (Object)lr.getStatus());
            }
            this.getViewer().refresh(true);
        }
    }
}

