/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs.controls;

import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.views.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ReminderVisibilityAndPopupComposite
extends Composite {
    private StackLayout stackLayout = new StackLayout();
    private Composite noPatientSelectedComposite;
    private Composite patientSelectedComposite;
    private Button popupOnLogin;
    private Button showOnlyOnSelectedPatient;
    private Combo comboPopup;
    private ComboViewer cvPopup;

    public ReminderVisibilityAndPopupComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)this.stackLayout);
        this.noPatientSelectedComposite = new Composite((Composite)this, 0);
        GridLayout gl_noPatientSelectedComposite = new GridLayout(2, false);
        gl_noPatientSelectedComposite.marginWidth = 0;
        gl_noPatientSelectedComposite.marginHeight = 0;
        this.noPatientSelectedComposite.setLayout((Layout)gl_noPatientSelectedComposite);
        Label popupIconLabel = new Label(this.noPatientSelectedComposite, 0);
        popupIconLabel.setImage(Images.IMG_BELL_EXCLAMATION.getImage());
        this.popupOnLogin = new Button(this.noPatientSelectedComposite, 32);
        this.popupOnLogin.setText(Visibility.POPUP_ON_LOGIN.getLocaleText());
        this.patientSelectedComposite = new Composite((Composite)this, 0);
        GridLayout gl_patientSelectedComposite = new GridLayout(4, false);
        gl_patientSelectedComposite.marginWidth = 0;
        gl_patientSelectedComposite.marginHeight = 0;
        this.patientSelectedComposite.setLayout((Layout)gl_patientSelectedComposite);
        Label visibilityLabel = new Label(this.patientSelectedComposite, 0);
        visibilityLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        visibilityLabel.setImage(Images.IMG_EYE_WO_SHADOW.getImage());
        this.showOnlyOnSelectedPatient = new Button(this.patientSelectedComposite, 32);
        this.showOnlyOnSelectedPatient.setText(Visibility.ON_PATIENT_SELECTION.getLocaleText());
        this.showOnlyOnSelectedPatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = ReminderVisibilityAndPopupComposite.this.showOnlyOnSelectedPatient.getSelection();
                if (!selection) {
                    ReminderVisibilityAndPopupComposite.this.cvPopup.setSelection((ISelection)StructuredSelection.EMPTY);
                }
                ReminderVisibilityAndPopupComposite.this.comboPopup.setEnabled(selection);
            }
        });
        this.showOnlyOnSelectedPatient.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label visibilityIconLabel = new Label(this.patientSelectedComposite, 0);
        visibilityIconLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        visibilityIconLabel.setImage(Images.IMG_BELL_EXCLAMATION.getImage());
        this.cvPopup = new ComboViewer(this.patientSelectedComposite, 0);
        this.comboPopup = this.cvPopup.getCombo();
        this.comboPopup.setEnabled(false);
        this.comboPopup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cvPopup.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvPopup.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Visibility) {
                    return ((Visibility)element).getLocaleText();
                }
                return element.toString();
            }
        });
        this.cvPopup.addSelectionChangedListener(s -> {
            StructuredSelection ss = (StructuredSelection)s.getSelection();
            Object firstElement = ss.getFirstElement();
            if (firstElement != null && firstElement != "") {
                this.showOnlyOnSelectedPatient.setSelection(true);
            }
        });
        this.cvPopup.setInput((Object)new Object[]{"", Visibility.POPUP_ON_PATIENT_SELECTION, Visibility.POPUP_ON_LOGIN});
    }

    protected void checkSubclass() {
    }

    public void selectVisibleControl(boolean withPatientRelation) {
        this.stackLayout.topControl = withPatientRelation ? this.patientSelectedComposite : this.noPatientSelectedComposite;
        this.layout();
    }

    public Visibility getConfiguredVisibility() {
        if (this.patientSelectedComposite.equals(this.stackLayout.topControl)) {
            if (this.showOnlyOnSelectedPatient.getSelection()) {
                Object firstElement = this.cvPopup.getStructuredSelection().getFirstElement();
                if (firstElement == null || "".equals(firstElement)) {
                    return Visibility.ON_PATIENT_SELECTION;
                }
                return (Visibility)firstElement;
            }
            return Visibility.ALWAYS;
        }
        if (this.popupOnLogin.getSelection()) {
            return Visibility.POPUP_ON_LOGIN;
        }
        return Visibility.ALWAYS;
    }

    public void setConfiguredVisibility(Visibility visibility, boolean withPatientRelation) {
        this.selectVisibleControl(withPatientRelation);
        if (this.noPatientSelectedComposite.equals(this.stackLayout.topControl)) {
            this.popupOnLogin.setSelection(Visibility.POPUP_ON_LOGIN == visibility);
        } else {
            if (visibility == null) {
                visibility = Visibility.ALWAYS;
                boolean defaultPatientRelated = ConfigServiceHolder.getUser((String)"reminder/defaultPatientRelated", (boolean)false);
                if (withPatientRelation && defaultPatientRelated) {
                    visibility = Visibility.ON_PATIENT_SELECTION;
                }
            }
            this.showOnlyOnSelectedPatient.setSelection(Visibility.ON_PATIENT_SELECTION == visibility);
            this.showOnlyOnSelectedPatient.setToolTipText(Messages.ReminderView_defaultPatientRelatedTooltip);
            this.showOnlyOnSelectedPatient.setToolTipText("Der Vorgabewert kann unter Einstellungen..Anwender..Pendenzen ge\u00e4ndert werden");
            this.comboPopup.setEnabled(true);
            if (Visibility.POPUP_ON_LOGIN == visibility || Visibility.POPUP_ON_PATIENT_SELECTION == visibility) {
                this.cvPopup.setSelection((ISelection)new StructuredSelection((Object)visibility));
            } else {
                this.cvPopup.setSelection((ISelection)new StructuredSelection((Object)""));
            }
        }
    }
}

