/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.types.AddressType;
import ch.elexis.core.types.LocalizeUtil;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.ZusatzAdresse;
import ch.elexis.data.dto.ZusatzAdresseDTO;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ZusatzAdresseEingabeDialog
extends TitleAreaDialog {
    private Text str1;
    private Text str2;
    private Text plz;
    private Text ort;
    private Text land;
    private Text postanschrift;
    private ComboViewer comboAddressType;
    private final ZusatzAdresseDTO zusatzAdresseDTO;
    private final ZusatzAdresse zusatzAdresse;
    private boolean locked = false;

    public ZusatzAdresseEingabeDialog(Shell parentShell, Kontakt kontakt) {
        this(parentShell, kontakt, null);
    }

    public ZusatzAdresseEingabeDialog(Shell parentShell, Kontakt kontakt, ZusatzAdresse paramZusatzadresse) {
        super(parentShell);
        this.zusatzAdresse = ZusatzAdresse.load((String)(paramZusatzadresse != null ? paramZusatzadresse.getId() : null));
        this.zusatzAdresseDTO = this.zusatzAdresse.getDTO();
        this.zusatzAdresseDTO.setKontaktId(kontakt.getId());
    }

    public ZusatzAdresseEingabeDialog(Shell parentShell, Kontakt kontakt, ZusatzAdresse paramZusatzadresse, boolean locked) {
        this(parentShell, kontakt, paramZusatzadresse);
        this.locked = locked;
    }

    public void create() {
        Button btnOk;
        super.create();
        this.setTitle(Messages.AnschriftEingabeDialog_enterAddress);
        this.setMessage(Messages.AnschriftEingabeDialog_enterData);
        this.getShell().setText(Messages.AnschriftEingabeDialog_postalAddress);
        if (this.locked && (btnOk = this.getButton(0)) != null) {
            btnOk.setEnabled(false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite com = new Composite(parent, 0);
        com.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        com.setLayout((Layout)new GridLayout(2, false));
        Composite compAddressType = new Composite(com, 0);
        compAddressType.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, true));
        compAddressType.setLayout((Layout)new GridLayout(2, false));
        Label lblAddressType = new Label(compAddressType, 0);
        lblAddressType.setText("Type");
        this.comboAddressType = new ComboViewer(compAddressType, 2060);
        this.comboAddressType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboAddressType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return LocalizeUtil.getLocaleText((Enumerator)((AddressType)element));
            }
        });
        ArrayList<AddressType> comboValues = new ArrayList<AddressType>(Arrays.asList(AddressType.values()));
        comboValues.remove(AddressType.PRINCIPAL_RESIDENCE);
        this.comboAddressType.setInput(comboValues);
        Label l1 = new Label(com, 0);
        l1.setText(String.valueOf(Messages.AnschriftEingabeDialog_street) + "1");
        this.str1 = new Text(com, 2048);
        this.str1.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        l1 = new Label(com, 0);
        l1.setText(String.valueOf(Messages.AnschriftEingabeDialog_street) + "2");
        this.str2 = new Text(com, 2048);
        this.str2.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        Label l2 = new Label(com, 0);
        l2.setText(Messages.AnschriftEingabeDialog_zip);
        this.plz = new Text(com, 2048);
        this.plz.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        Label l3 = new Label(com, 0);
        l3.setText(Messages.AnschriftEingabeDialog_city);
        this.ort = new Text(com, 2048);
        this.ort.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        Label l4 = new Label(com, 0);
        l4.setText(Messages.AnschriftEingabeDialog_country);
        this.land = new Text(com, 2048);
        this.land.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        Button post = new Button(com, 8);
        post.setText(Messages.AnschriftEingabeDialog_postalAddress);
        post.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZusatzAdresseEingabeDialog.this.setFieldValues();
                Kontakt kontakt = Kontakt.load((String)ZusatzAdresseEingabeDialog.this.zusatzAdresseDTO.getKontaktId());
                ZusatzAdresseEingabeDialog.this.zusatzAdresseDTO.setPostalAddress(String.valueOf(kontakt.getSalutation()) + ZusatzAdresseEingabeDialog.this.zusatzAdresse.getEtikette(false, true, ZusatzAdresseEingabeDialog.this.zusatzAdresseDTO.getKontaktId(), ZusatzAdresseEingabeDialog.this.zusatzAdresseDTO.getStreet1(), ZusatzAdresseEingabeDialog.this.zusatzAdresseDTO.getCountry(), ZusatzAdresseEingabeDialog.this.zusatzAdresseDTO.getZip(), ZusatzAdresseEingabeDialog.this.zusatzAdresseDTO.getPlace()));
                ZusatzAdresseEingabeDialog.this.loadFieldValues();
            }
        });
        this.postanschrift = new Text(com, 2050);
        GridData gd = SWTHelper.getFillGridData(1, true, 1, true);
        Point size = this.postanschrift.computeSize(-1, -1, true);
        gd.heightHint = 4 * size.y;
        this.postanschrift.setLayoutData((Object)gd);
        new Label(com, 0);
        Label l5 = new Label(com, 0);
        l5.setText(Messages.AnschriftEingabeDialog_postalAddressInfo);
        l5.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.loadFieldValues();
        return com;
    }

    private void loadFieldValues() {
        this.str1.setText(this.zusatzAdresseDTO.getStreet1());
        this.str2.setText(this.zusatzAdresseDTO.getStreet2());
        this.plz.setText(this.zusatzAdresseDTO.getZip());
        this.ort.setText(this.zusatzAdresseDTO.getPlace());
        this.land.setText(this.zusatzAdresseDTO.getCountry());
        this.comboAddressType.setSelection((ISelection)new StructuredSelection((Object)this.zusatzAdresseDTO.getAddressType()));
        this.postanschrift.setText(this.zusatzAdresseDTO.getPostalAddress().replaceAll("[\\r\\n]\\n", "\n"));
    }

    private void setFieldValues() {
        this.zusatzAdresseDTO.setStreet1(this.str1.getText());
        this.zusatzAdresseDTO.setStreet2(this.str2.getText());
        this.zusatzAdresseDTO.setZip(StringUtils.substring((String)this.plz.getText(), (int)0, (int)6));
        this.zusatzAdresseDTO.setPlace(this.ort.getText());
        this.zusatzAdresseDTO.setCountry(StringUtils.substring((String)this.land.getText(), (int)0, (int)3));
        StructuredSelection selection = (StructuredSelection)this.comboAddressType.getSelection();
        if (selection != null && !selection.isEmpty()) {
            AddressType addressType = (AddressType)selection.getFirstElement();
            this.zusatzAdresseDTO.setAddressType(addressType);
        }
        this.zusatzAdresseDTO.setPostalAddress(this.postanschrift.getText().replaceAll("\\r\\n", "\n"));
    }

    protected void okPressed() {
        this.setFieldValues();
        try {
            this.zusatzAdresse.persistDTO(this.zusatzAdresseDTO);
        }
        catch (ElexisException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"", (String)"Speichern nicht m\u00f6glich. Bitte diesen Dialog schlie\u00dfen und erneut probieren.");
            return;
        }
        super.okPressed();
    }

    public ZusatzAdresse getZusatzAdresse() {
        return this.zusatzAdresse;
    }
}

