/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.ui.dialogs.base.InputDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaTray;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TextTemplatePrintSettingsDialog
extends TitleAreaDialog {
    private ComboViewer cvPrinters;
    private ComboViewer cvTrays;
    private List<PrintService> printServices = Arrays.asList(PrintServiceLookup.lookupPrintServices(null, null));
    private List<MediaTray> mediaTrays = new ArrayList<MediaTray>();
    private String selPrinter;
    private String selTray;

    public TextTemplatePrintSettingsDialog(Shell parentShell, String printer, String tray) {
        super(parentShell);
        this.selPrinter = printer;
        this.selTray = tray;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Textvorlagen Druckeinstellungen");
        this.setMessage("Bitte Drucker und Druckschacht f\u00fcr diese Vorlage definieren");
        this.setTitleImage(Images.IMG_PRINTER_BIG.getImage());
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(3, false));
        area.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        Label lblPrinter = new Label(area, 0);
        lblPrinter.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPrinter.setText("Drucker");
        this.cvPrinters = new ComboViewer(area, 8);
        Combo comboPrinters = this.cvPrinters.getCombo();
        comboPrinters.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cvPrinters.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvPrinters.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof PrintService) {
                    PrintService ps = (PrintService)element;
                    return ps.getName();
                }
                return super.getText(element);
            }
        });
        this.cvPrinters.setInput(this.printServices);
        this.cvPrinters.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    PrintService printService = (PrintService)selection.getFirstElement();
                    TextTemplatePrintSettingsDialog.this.loadAvailableTrays(printService);
                    TextTemplatePrintSettingsDialog.this.cvTrays.setInput(TextTemplatePrintSettingsDialog.this.mediaTrays);
                    TextTemplatePrintSettingsDialog.this.cvTrays.refresh();
                }
            }
        });
        Label lblTray = new Label(area, 0);
        lblTray.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTray.setText("Schacht");
        this.cvTrays = new ComboViewer(area, 8);
        Combo comboTrays = this.cvTrays.getCombo();
        comboTrays.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cvTrays.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvTrays.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof MediaTray) {
                    MediaTray mt = (MediaTray)element;
                    return mt.toString();
                }
                return super.getText(element);
            }
        });
        this.cvTrays.setInput(this.mediaTrays);
        Button addTrayButton = new Button(area, 8);
        addTrayButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        addTrayButton.setImage(Images.IMG_ADDITEM.getImage());
        addTrayButton.setToolTipText("Zus\u00e4tzlicher Schacht");
        addTrayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dlg = new InputDialog(TextTemplatePrintSettingsDialog.this.getParentShell(), "Zus\u00e4tzlicher Schacht", "Bitten den Namen des zus\u00e4tzlichen Schacht konfigurieren.", "", null, 0);
                if (dlg.open() == 0 && dlg.getValue() != null && !dlg.getValue().isEmpty()) {
                    TextTemplatePrintSettingsDialog.this.addCustomMediaTray(dlg.getValue());
                }
            }
        });
        this.initSelection();
        return area;
    }

    private void initSelection() {
        if (this.selPrinter == null) {
            PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
            if (defaultPrintService != null && this.printServices.contains(defaultPrintService)) {
                this.cvPrinters.setSelection((ISelection)new StructuredSelection((Object)defaultPrintService));
            }
        } else {
            for (PrintService ps : this.printServices) {
                if (!ps.getName().equals(this.selPrinter)) continue;
                this.cvPrinters.setSelection((ISelection)new StructuredSelection((Object)ps));
            }
        }
        if (!this.mediaTrays.isEmpty()) {
            if (this.selTray == null) {
                this.cvTrays.setSelection((ISelection)new StructuredSelection((Object)this.mediaTrays.get(0)));
            } else {
                boolean foundTray = false;
                for (MediaTray mt : this.mediaTrays) {
                    if (!mt.toString().equals(this.selTray)) continue;
                    this.cvTrays.setSelection((ISelection)new StructuredSelection((Object)mt));
                    foundTray = true;
                    break;
                }
                if (!foundTray) {
                    this.addCustomMediaTray(this.selTray);
                }
            }
        }
    }

    private void addCustomMediaTray(String name) {
        CustomMediaTray customTray = new CustomMediaTray(name);
        this.mediaTrays.add(customTray);
        this.cvTrays.setInput(this.mediaTrays);
        this.cvTrays.refresh();
        this.cvTrays.setSelection((ISelection)new StructuredSelection((Object)customTray));
    }

    private List<MediaTray> loadAvailableTrays(PrintService printService) {
        this.mediaTrays = new ArrayList<MediaTray>();
        Object attributes = printService.getSupportedAttributeValues(Media.class, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        if (attributes != null && attributes.getClass().isArray()) {
            Media[] mediaArray = (Media[])attributes;
            int n = mediaArray.length;
            int n2 = 0;
            while (n2 < n) {
                Media media = mediaArray[n2];
                if (media instanceof MediaTray) {
                    this.mediaTrays.add((MediaTray)media);
                }
                ++n2;
            }
        }
        return this.mediaTrays;
    }

    protected void okPressed() {
        IStructuredSelection selMediaTray;
        IStructuredSelection selPrintService = (IStructuredSelection)this.cvPrinters.getSelection();
        if (selPrintService != null && !selPrintService.isEmpty()) {
            this.selPrinter = ((PrintService)selPrintService.getFirstElement()).getName();
        }
        if ((selMediaTray = (IStructuredSelection)this.cvTrays.getSelection()) != null) {
            this.selTray = selMediaTray.isEmpty() ? "" : ((MediaTray)selMediaTray.getFirstElement()).toString();
        }
        super.okPressed();
    }

    public String getPrinter() {
        return this.selPrinter;
    }

    public String getMediaTray() {
        return this.selTray;
    }

    protected boolean isResizable() {
        return true;
    }

    private class CustomMediaTray
    extends MediaTray {
        private String name;

        protected CustomMediaTray(String name) {
            super(-1);
            this.name = name;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

