/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.l10n.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StatusDialog {
    public static void show(IStatus status) {
        if (!status.getMessage().isEmpty()) {
            if (status.isOK()) {
                StatusDialog.showInfo(status);
            } else if (StatusDialog.isWarnining(status)) {
                StatusDialog.showWarninig(status);
            } else {
                StatusDialog.showError(status);
            }
        }
    }

    private static boolean isWarnining(IStatus status) {
        return 2 == status.getSeverity();
    }

    private static void showError(IStatus status) {
        MessageDialog.openError((Shell)StatusDialog.getShell(), (String)Messages.ResultDialog_Error, (String)StatusDialog.getStatusMessage(status));
    }

    private static void showWarninig(IStatus status) {
        MessageDialog.openWarning((Shell)StatusDialog.getShell(), (String)Messages.ResultDialog_Warning, (String)StatusDialog.getStatusMessage(status));
    }

    private static void showInfo(IStatus status) {
        MessageDialog.openInformation((Shell)StatusDialog.getShell(), (String)Messages.ResultDialog_Info, (String)StatusDialog.getStatusMessage(status));
    }

    private static String getStatusMessage(IStatus status) {
        return status.getMessage();
    }

    private static Shell getShell() {
        return Display.getDefault().getActiveShell();
    }
}

