/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IArticleDefaultSignature;
import ch.elexis.core.ui.views.controls.ArticleDefaultSignatureComposite;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PrescriptionSignatureTitleAreaDialog
extends TitleAreaDialog {
    private IArticle article;
    private ArticleDefaultSignatureComposite adsc;
    private Button btnAsDefault;
    private IArticleDefaultSignature signature;
    private boolean medicationTypeFix;
    private boolean performLookup;

    public PrescriptionSignatureTitleAreaDialog(Shell parentShell, IArticle article) {
        super(parentShell);
        this.article = article;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Verordnungssignatur");
        this.setMessage("Die Signatur der Verordnung von " + this.article.getLabel());
        Composite area = (Composite)super.createDialogArea(parent);
        this.btnAsDefault = new Button(area, 32);
        this.btnAsDefault.setText("Als Standardsignatur hinterlegen.");
        this.btnAsDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrescriptionSignatureTitleAreaDialog.this.adsc.setOnLocationEnabled(PrescriptionSignatureTitleAreaDialog.this.btnAsDefault.getSelection());
            }
        });
        GridData gd = new GridData();
        gd.horizontalIndent = 5;
        gd.verticalIndent = 5;
        this.btnAsDefault.setLayoutData((Object)gd);
        this.adsc = new ArticleDefaultSignatureComposite(area, 0);
        this.adsc.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.adsc.initDataBindings(null);
        this.adsc.setToolbarVisible(false);
        this.adsc.setStartVisible(true);
        this.adsc.setOnLocationEnabled(false);
        this.adsc.setArticleToBind(this.article, false);
        if (this.performLookup) {
            this.adsc.setArticleToBind(this.article, true);
        }
        if (this.signature != null) {
            this.adsc.setSignature(this.signature);
        }
        if (this.medicationTypeFix) {
            this.adsc.setMedicationTypeFix();
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.adsc.updateModelNonDatabinding();
        if (this.btnAsDefault.getSelection()) {
            this.adsc.save();
        }
        super.okPressed();
    }

    public void setMedicationTypeFix(boolean value) {
        this.medicationTypeFix = value;
    }

    public void lookup() {
        if (this.adsc != null && !this.adsc.isDisposed()) {
            this.adsc.setArticleToBind(this.article, true);
        } else {
            this.performLookup = true;
        }
    }

    public void setSignature(IArticleDefaultSignature s) {
        this.signature = s;
    }

    public IArticleDefaultSignature getSignature() {
        return this.adsc.getSignature();
    }
}

