/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.views.FallDetailBlatt2;
import ch.elexis.data.Fall;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class NeuerFallDialog
extends TitleAreaDialog {
    Fall fall;
    Patient pat;
    private FallDetailBlatt2 fdb;
    private final boolean deleteOnCancel;

    public NeuerFallDialog(Shell shell, Fall f) {
        super(shell);
        this.fall = f;
        if (this.fall == null) {
            this.pat = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
            this.fall = this.pat.neuerFall(Fall.getDefaultCaseLabel(), Fall.getDefaultCaseReason(), Fall.getDefaultCaseLaw());
        }
        this.deleteOnCancel = true;
    }

    public NeuerFallDialog(Shell shell, Patient pat, boolean deleteOnCancel) {
        super(shell);
        this.pat = pat;
        this.fall = pat.neuerFall(Fall.getDefaultCaseLabel(), Fall.getDefaultCaseReason(), Fall.getDefaultCaseLaw());
        this.deleteOnCancel = deleteOnCancel;
    }

    protected Control createDialogArea(Composite parent) {
        this.fdb = new FallDetailBlatt2(parent);
        this.fdb.setFall((IFall)this.fall);
        this.fdb.setUnlocked(true);
        this.fdb.setLockUpdate(false);
        return this.fdb;
    }

    public void create() {
        super.create();
        this.setMessage(Messages.NeuerFallDialog_enterCaseData);
        this.setTitle(Messages.NeuerFallDialog_createNewCase);
        this.getShell().setText(Messages.NeuerFallDialog_newCase);
    }

    protected void okPressed() {
        if (LocalLockServiceHolder.get().acquireLock((Object)this.fall).isOk()) {
            this.fdb.save();
            LocalLockServiceHolder.get().releaseLock((Object)this.fall);
        }
        ElexisEventDispatcher.update((PersistentObject)this.fall);
        super.okPressed();
    }

    protected void cancelPressed() {
        if (this.deleteOnCancel) {
            this.fall.delete();
        }
        ElexisEventDispatcher.reload(Fall.class);
        super.cancelPressed();
    }

    public Fall getFall() {
        return this.fall;
    }

    protected boolean isResizable() {
        return true;
    }
}

