/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.ui.dialogs.FallEditDialog;
import ch.elexis.core.ui.dialogs.NeuerFallDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Patient;
import ch.elexis.data.dto.FallDTO;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public class FallSelectionDialog
extends TitleAreaDialog {
    private final String message;
    private final FallDTO currentFall;
    private TableViewer tableViewer;
    private Composite ret;
    private Optional<IFall> selectedFall = Optional.empty();

    public FallSelectionDialog(Shell parentShell, String message, FallDTO currentFall) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.message = message;
        this.currentFall = currentFall;
    }

    protected Control createDialogArea(Composite parent) {
        this.selectedFall = Optional.empty();
        this.ret = new Composite(parent, 0);
        GridLayout gd = new GridLayout(1, false);
        gd.marginTop = 10;
        this.ret.setLayout((Layout)gd);
        this.ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        Patient patient = this.currentFall.getPatient();
        if (patient == null || !patient.exists()) {
            Label lblPatient = new Label(this.ret, 0);
            lblPatient.setText("Kein Patient ausgew\u00e4hlt!");
        } else {
            Text txtPatient = new Text(this.ret, 8);
            txtPatient.setText("Patient: " + this.currentFall.getPatient().getLabel());
            Composite part = new Composite(this.ret, 0);
            part.setLayout((Layout)new GridLayout(2, false));
            part.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            final Button btnCheck = new Button(part, 32);
            btnCheck.setText("Geschlossene F\u00e4lle auch anzeigen");
            btnCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FallSelectionDialog.this.refresh(btnCheck.getSelection());
                }
            });
            ToolBarManager tbManager = new ToolBarManager(8388928);
            tbManager.add((IAction)new Action("Neuer Fall"){

                public ImageDescriptor getImageDescriptor() {
                    return Images.IMG_NEW.getImageDescriptor();
                }

                public String getToolTipText() {
                    return "Neuer Fall";
                }

                public void run() {
                    Fall neuerFall;
                    NeuerFallDialog neuerFallDialog = new NeuerFallDialog(FallSelectionDialog.this.getShell(), FallSelectionDialog.this.currentFall.getPatient(), true);
                    if (neuerFallDialog.open() == 0 && (neuerFall = neuerFallDialog.getFall()) != null && neuerFall.exists()) {
                        if (LocalLockServiceHolder.get().acquireLock((Object)neuerFallDialog.getFall()).isOk()) {
                            FallSelectionDialog.this.refresh(btnCheck.getSelection());
                            FallSelectionDialog.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)neuerFall));
                            LocalLockServiceHolder.get().releaseLock((Object)neuerFallDialog.getFall());
                        } else {
                            MessageDialog.openWarning((Shell)FallSelectionDialog.this.getShell(), (String)"Lock nicht erhalten", (String)"Lock nicht erhalten. Diese Operation ist derzeit nicht m\u00f6glich.");
                        }
                    }
                }
            });
            ToolBar toolbar = tbManager.createControl(part);
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)toolbar);
            Composite tableComposite = new Composite(this.ret, 0);
            GridData gdTable = SWTHelper.getFillGridData(1, true, 1, true);
            gdTable.heightHint = 200;
            tableComposite.setLayoutData((Object)gdTable);
            this.tableViewer = new TableViewer(tableComposite, 67584);
            this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.tableViewer.getTable().setHeaderVisible(true);
            this.tableViewer.getTable().setLinesVisible(true);
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    Fall f = (Fall)element;
                    return f.getLabel();
                }
            });
            this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object firstElement = selection.getFirstElement();
                    if (firstElement instanceof Fall) {
                        if (LocalLockServiceHolder.get().acquireLock((Object)((Fall)firstElement)).isOk()) {
                            FallEditDialog fallEditDialog = new FallEditDialog(FallSelectionDialog.this.getShell(), (Fall)firstElement);
                            fallEditDialog.open();
                            if (fallEditDialog.getFall() != null) {
                                LocalLockServiceHolder.get().releaseLock((Object)fallEditDialog.getFall());
                            }
                        } else {
                            MessageDialog.openWarning((Shell)FallSelectionDialog.this.getShell(), (String)"Lock nicht erhalten", (String)"Lock nicht erhalten. Diese Operation ist derzeit nicht m\u00f6glich.");
                        }
                        FallSelectionDialog.this.refresh(btnCheck.getSelection());
                    }
                }
            });
            TableColumn singleColumn = new TableColumn(this.tableViewer.getTable(), 0);
            singleColumn.setText("F\u00e4lle");
            TableColumnLayout tableColumnLayout = new TableColumnLayout();
            tableColumnLayout.setColumnData((Widget)singleColumn, (ColumnLayoutData)new ColumnWeightData(100));
            tableComposite.setLayout((Layout)tableColumnLayout);
            this.refresh(btnCheck.getSelection());
            this.ret.pack();
        }
        return this.ret;
    }

    private void refresh(boolean showClosed) {
        Patient patient;
        if (this.tableViewer != null && this.ret != null && (patient = this.currentFall.getPatient()) != null && patient.exists()) {
            ArrayList<Fall> faelle = new ArrayList<Fall>();
            Fall[] fallArray = patient.getFaelle();
            int n = fallArray.length;
            int n2 = 0;
            while (n2 < n) {
                Fall f = fallArray[n2];
                if (!f.getId().equals(this.currentFall.getId()) && (showClosed || f.isOpen())) {
                    faelle.add(f);
                }
                ++n2;
            }
            this.tableViewer.setInput(faelle);
            this.tableViewer.refresh();
            this.ret.layout(true, true);
        }
    }

    public void create() {
        super.create();
        this.setTitle("Fallauswahl");
        this.setMessage(this.message);
    }

    protected void okPressed() {
        Object o;
        IStructuredSelection iSelection = (IStructuredSelection)this.tableViewer.getSelection();
        if (iSelection != null && (o = iSelection.getFirstElement()) instanceof IFall) {
            this.selectedFall = Optional.of((IFall)o);
        }
        super.okPressed();
    }

    public Optional<IFall> getSelectedFall() {
        return this.selectedFall;
    }
}

