/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.coolbar;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.data.UiMandant;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.data.Anwender;
import ch.elexis.data.Mandant;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MandantSelectionContributionItem {
    private ToolItem item;
    private Menu menu;
    private Mandant[] mandants;
    private MenuItem[] menuItems;
    private ToolBar fParent;
    private ElexisEventListener eeli_mandant = new ElexisUiEventListenerImpl(Mandant.class, 128){

        @Override
        public void runInUi(ElexisEvent ev) {
            Mandant m = (Mandant)ev.getObject();
            if (m != null && MandantSelectionContributionItem.this.item != null) {
                MandantSelectionContributionItem.this.item.setText(m.getMandantLabel());
                MandantSelectionContributionItem.this.fParent.setBackground(UiMandant.getColorForMandator(m));
                if (MandantSelectionContributionItem.this.menuItems == null) {
                    MandantSelectionContributionItem.this.fParent.pack();
                    return;
                }
                int i = 0;
                while (i < MandantSelectionContributionItem.this.menuItems.length) {
                    String id = (String)MandantSelectionContributionItem.this.menuItems[i].getData();
                    if (m.getId().equalsIgnoreCase(id)) {
                        MandantSelectionContributionItem.this.fParent.pack();
                        MandantSelectionContributionItem.this.menuItems[i].setSelection(true);
                    } else {
                        MandantSelectionContributionItem.this.menuItems[i].setSelection(false);
                    }
                    ++i;
                }
            }
            MandantSelectionContributionItem.this.fParent.getParent().layout();
        }
    };
    private ElexisEventListener eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        @Override
        public void runInUi(ElexisEvent ev) {
            if (MandantSelectionContributionItem.this.item != null) {
                Anwender anwender = (Anwender)ev.getObject();
                MandantSelectionContributionItem.this.adaptForAnwender(anwender);
            }
        }
    };
    private final Listener selectionListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.detail == 4 || event.type == 13) {
                Rectangle rect = MandantSelectionContributionItem.this.item.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = MandantSelectionContributionItem.this.fParent.toDisplay(pt);
                MandantSelectionContributionItem.this.menu.setLocation(pt.x, pt.y);
                MandantSelectionContributionItem.this.menu.setVisible(true);
            }
        }
    };

    private void adaptForAnwender(Anwender anwender) {
        if (anwender == null && (anwender = CoreHub.getLoggedInContact()) == null) {
            return;
        }
        List exDocStr = anwender.getExecutiveDoctorsWorkingFor().stream().map(a -> a.getId()).collect(Collectors.toList());
        int i = 0;
        while (i < this.menuItems.length) {
            String id = (String)this.menuItems[i].getData();
            this.menuItems[i].setEnabled(exDocStr.contains(id));
            ++i;
        }
    }

    public MandantSelectionContributionItem() {
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_mandant, this.eeli_user});
    }

    @PostConstruct
    protected Control createControl(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 0);
        this.disposeItems();
        if (this.item != null) {
            this.item.dispose();
        }
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.fParent = toolbar;
        this.menu = new Menu((Control)this.fParent);
        List<Mandant> qre = Hub.getMandantenList();
        qre.sort(new Comparator<Mandant>(){

            @Override
            public int compare(Mandant m1, Mandant m2) {
                return m1.getMandantLabel().compareTo(m2.getMandantLabel());
            }
        });
        this.mandants = qre.toArray(new Mandant[0]);
        if (this.mandants.length < 2) {
            return null;
        }
        this.item = new ToolItem(toolbar, 4);
        this.item.setToolTipText("Aktuell ausgew\u00e4hlter Mandant bzw. Mandantenauswahl");
        this.menuItems = new MenuItem[this.mandants.length];
        int i = 0;
        while (i < this.mandants.length) {
            final Mandant m = this.mandants[i];
            this.menuItems[i] = new MenuItem(this.menu, 16);
            this.menuItems[i].setText(m.getMandantLabel());
            this.menuItems[i].setImage(MandantSelectionContributionItem.getBoxSWTColorImage(UiMandant.getColorForMandator(m)));
            this.menuItems[i].setData((Object)m.getId());
            this.menuItems[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Hub.setMandant(m);
                }
            });
            if (CoreHub.actMandant != null) {
                this.menuItems[i].setSelection(CoreHub.actMandant.equals((Object)m));
            }
            ++i;
        }
        this.item.addListener(13, this.selectionListener);
        if (CoreHub.actMandant != null && this.item != null) {
            this.item.setText(CoreHub.actMandant.getMandantLabel());
            this.fParent.setBackground(UiMandant.getColorForMandator(CoreHub.actMandant));
        }
        this.adaptForAnwender(null);
        toolbar.pack();
        return toolbar;
    }

    private void disposeItems() {
        if (this.menuItems != null && this.menuItems.length > 0) {
            int i = 0;
            while (i < this.menuItems.length) {
                if (this.menuItems[i] != null) {
                    Image img = this.menuItems[i].getImage();
                    if (img != null) {
                        img.dispose();
                    }
                    this.menuItems[i].dispose();
                }
                ++i;
            }
        }
    }

    public static Image getBoxSWTColorImage(Color color) {
        Display display = Display.getCurrent();
        Image image = new Image((Device)display, 16, 16);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.fillRoundRectangle(0, 0, 16, 16, 8, 8);
        gc.setForeground(display.getSystemColor(2));
        gc.dispose();
        return image;
    }

    @PreDestroy
    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_mandant, this.eeli_user});
    }
}

