/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.util.LocalLock;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.util.DocumentLetterUtil;
import ch.elexis.core.services.IConflictHandler;
import ch.elexis.core.services.IElexisServerService;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ElexisServerServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.commands.Messages;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.services.LocalDocumentServiceHolder;
import ch.elexis.data.Brief;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.LoggerFactory;

public class StartEditLocalDocumentHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEclipseContext iEclipseContext = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        StructuredSelection selection = (StructuredSelection)iEclipseContext.get(event.getCommand().getId().concat(".selection"));
        iEclipseContext.remove(event.getCommand().getId().concat(".selection"));
        if (selection != null && !selection.isEmpty()) {
            List selected = selection.toList();
            final Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            for (Object object : selected) {
                Optional<ILocalDocumentService> localDocumentService = LocalDocumentServiceHolder.getService();
                if (!localDocumentService.isPresent()) continue;
                final ILocalDocumentService service = localDocumentService.get();
                if (ElexisServerServiceHolder.get().getConnectionStatus() == IElexisServerService.ConnectionStatus.REMOTE) {
                    Identifiable lockObject;
                    boolean isHandledExternalOpen;
                    if (object instanceof IPersistentObject) {
                        final IPersistentObject lockObject2 = (IPersistentObject)object;
                        boolean isHandledByExternalOpen = this.tryHandleExternalIfApplicable(lockObject2);
                        if (isHandledByExternalOpen) continue;
                        AcquireLockUi.aquireAndRun(lockObject2, new ILockHandler(){

                            @Override
                            public void lockFailed() {
                            }

                            @Override
                            public void lockAcquired() {
                                StartEditLocalDocumentHandler.this.startEditLocal(lockObject2, service, parentShell);
                            }
                        });
                        continue;
                    }
                    if (!(object instanceof Identifiable) || (isHandledExternalOpen = this.tryHandleExternalIfApplicable(lockObject = (Identifiable)object))) continue;
                    AcquireLockUi.aquireAndRun(lockObject, new ILockHandler(){

                        @Override
                        public void lockFailed() {
                        }

                        @Override
                        public void lockAcquired() {
                            StartEditLocalDocumentHandler.this.startEditLocal(lockObject, service, parentShell);
                        }
                    });
                    continue;
                }
                boolean isHandledExternalOpen = this.tryHandleExternalIfApplicable(object);
                if (isHandledExternalOpen) continue;
                LocalLock lock = new LocalLock(object);
                if (!lock.tryLock()) {
                    if (service.contains(object) && lock.hasLock(CoreHub.getLoggedInContact().getLabel()) || MessageDialog.openQuestion((Shell)parentShell, (String)Messages.StartEditLocalDocumentHandler_warning, (String)(String.valueOf(Messages.StartEditLocalDocumentHandler_alreadyOpenStart) + lock.getLockMessage() + Messages.StartEditLocalDocumentHandler_alreadyOpenEnd))) {
                        lock.unlock();
                        if (!lock.tryLock()) {
                            MessageDialog.openError((Shell)parentShell, (String)Messages.StartEditLocalDocumentHandler_errortitle, (String)Messages.StartEditLocalDocumentHandler_errormessage);
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                this.startEditLocal(object, service, parentShell);
            }
        }
        return null;
    }

    private boolean tryHandleExternalIfApplicable(Object lockObject) {
        if (ConfigServiceHolder.getGlobal((String)"briefe/Textmodul_Extern_File", (boolean)false) && lockObject != null) {
            IDocument document = null;
            if (lockObject instanceof Brief) {
                document = ((Brief)lockObject).toIDocument();
            } else if (lockObject instanceof IDocumentLetter) {
                document = (IDocumentLetter)lockObject;
            } else {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Invalid argument [{}]", lockObject.getClass());
                return false;
            }
            IVirtualFilesystemService.IVirtualFilesystemHandle handle = DocumentLetterUtil.getExternalHandleIfApplicable((IDocument)document);
            Optional file = handle.toFile();
            if (file.isPresent()) {
                Program.launch((String)((File)file.get()).getAbsolutePath());
            } else {
                MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)Messages.StartEditLocalDocumentHandler_errortitle, (String)Messages.StartEditLocalDocumentHandler_errormessage);
            }
            return true;
        }
        return false;
    }

    private void startEditLocal(Object object, ILocalDocumentService service, final Shell parentShell) {
        Optional file = service.add(object, new IConflictHandler(){

            public IConflictHandler.Result getResult() {
                if (MessageDialog.openQuestion((Shell)parentShell, (String)Messages.StartEditLocalDocumentHandler_conflicttitle, (String)Messages.StartEditLocalDocumentHandler_conflictmessage)) {
                    return IConflictHandler.Result.KEEP;
                }
                return IConflictHandler.Result.OVERWRITE;
            }
        });
        if (file.isPresent()) {
            Program.launch((String)((File)file.get()).getAbsolutePath());
        } else {
            MessageDialog.openError((Shell)parentShell, (String)Messages.StartEditLocalDocumentHandler_errortitle, (String)Messages.StartEditLocalDocumentHandler_errormessage);
        }
    }
}

