/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.Tree;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalEventDispatcher
implements IPartListener2 {
    private static Logger logger = LoggerFactory.getLogger(GlobalEventDispatcher.class);
    private static GlobalEventDispatcher theInstance;
    private final ConcurrentHashMap<IWorkbenchPart, LinkedList<IActivationListener>> activationListeners;
    private final GlobalListener globalListener = new GlobalListener();

    private GlobalEventDispatcher() {
        this.activationListeners = new ConcurrentHashMap();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
    }

    public static synchronized GlobalEventDispatcher getInstance() {
        if (theInstance == null) {
            theInstance = new GlobalEventDispatcher();
        }
        return theInstance;
    }

    public GlobalListener getDefaultListener() {
        return this.globalListener;
    }

    public static void addActivationListener(IActivationListener l, IWorkbenchPart part) {
        logger.debug("addActivationListener adding " + l + " for " + part);
        LinkedList<IActivationListener> list = GlobalEventDispatcher.getInstance().activationListeners.get(part);
        if (list == null) {
            list = new LinkedList();
            GlobalEventDispatcher.getInstance().activationListeners.put(part, list);
        }
        list.add(l);
    }

    public static void removeActivationListener(IActivationListener l, IWorkbenchPart part) {
        LinkedList<IActivationListener> list = GlobalEventDispatcher.getInstance().activationListeners.get(part);
        if (list != null) {
            list.remove(l);
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        LinkedList<IActivationListener> list = this.activationListeners.get(partRef.getPart(false));
        if (list != null) {
            for (IActivationListener l : list) {
                l.activation(true);
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
        LinkedList<IActivationListener> list = this.activationListeners.get(partRef.getPart(false));
        if (list != null) {
            for (IActivationListener l : list) {
                l.activation(false);
            }
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        logger.debug("partHidden " + partRef.getPart(false));
        LinkedList<IActivationListener> list = this.activationListeners.get(partRef.getPart(false));
        if (list != null) {
            for (IActivationListener l : list) {
                logger.debug("Calling partHidden listener " + l);
                l.visible(false);
            }
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        logger.debug("partVisible " + partRef.getPart(false));
        LinkedList<IActivationListener> list = this.activationListeners.get(partRef.getPart(false));
        if (list != null) {
            for (IActivationListener l : list) {
                logger.debug("Calling partVisible listener " + l);
                l.visible(true);
            }
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    private static class GlobalListener
    implements ISelectionChangedListener {
        private GlobalListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection sel = (StructuredSelection)event.getSelection();
            Object[] obj = sel.toArray();
            if (obj != null && obj.length != 0) {
                if (obj[0] instanceof PersistentObject) {
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((PersistentObject)obj[0]));
                } else if (obj[0] instanceof Tree) {
                    Tree t = (Tree)obj[0];
                    if (t.contents instanceof PersistentObject) {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((PersistentObject)t.contents));
                    }
                }
            }
        }
    }
}

