/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.PersistentObjectLoader;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;

public class FlatDataLoader
extends PersistentObjectLoader
implements ILazyContentProvider {
    private List<? extends PersistentObject> raw = null;
    private List<? extends PersistentObject> filtered = null;

    public FlatDataLoader(CommonViewer cv, Query<? extends PersistentObject> qbe) {
        super(cv, qbe);
    }

    public FlatDataLoader(Query<? extends PersistentObject> qbe) {
        super(null, qbe);
    }

    @Override
    public IStatus work(IProgressMonitor monitor, HashMap<String, Object> params) {
        if (this.isSuspended()) {
            return Status.CANCEL_STATUS;
        }
        final TableViewer tv = (TableViewer)this.cv.getViewerWidget();
        if (this.filtered != null) {
            this.filtered.clear();
        }
        this.filtered = null;
        this.setQuery();
        this.applyQueryFilters();
        if (this.orderFields != null) {
            this.qbe.orderBy(false, this.orderFields);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.raw = this.qbe.execute();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        UiDesk.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (tv != null && !tv.getTable().isDisposed()) {
                    tv.setItemCount(0);
                    FlatDataLoader.this.filtered = FlatDataLoader.this.raw;
                    tv.setItemCount(FlatDataLoader.this.raw.size());
                }
            }
        });
        return Status.OK_STATUS;
    }

    public void setResult(List<PersistentObject> res) {
        this.raw = res;
    }

    protected void setQuery() {
        this.qbe.clear();
        ViewerConfigurer.ControlFieldProvider cfp = this.cv.getConfigurer().getControlFieldProvider();
        if (cfp != null) {
            cfp.setQuery((Query<? extends PersistentObject>)this.qbe);
        }
    }

    public void updateElement(int index) {
        PersistentObject o;
        if (this.filtered != null && index >= 0 && index < this.filtered.size() && (o = this.filtered.get(index)) != null) {
            TableViewer tv = (TableViewer)this.cv.getViewerWidget();
            tv.replace((Object)this.filtered.get(index), index);
        }
    }
}

