/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui;

import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class UiDesk {
    private static FormToolkit theToolkit = null;
    private static Display theDisplay = null;
    private static ImageRegistry theImageRegistry = null;
    private static ColorRegistry theColorRegistry = null;
    private static HashMap<String, Cursor> cursors = null;
    public static final String COL_RED = "rot";
    public static final String COL_GREEN = "gruen";
    public static final String COL_DARKGREEN = "dunkelgruen";
    public static final String COL_BLUE = "blau";
    public static final String COL_SKYBLUE = "himmelblau";
    public static final String COL_LIGHTBLUE = "hellblau";
    public static final String COL_BLACK = "schwarz";
    public static final String COL_GREY = "grau";
    public static final String COL_WHITE = "weiss";
    public static final String COL_DARKGREY = "dunkelgrau";
    public static final String COL_LIGHTGREY = "hellgrau";
    public static final String COL_GREY60 = "grau60";
    public static final String COL_GREY20 = "grau20";
    public static final String CUR_HYPERLINK = "cursor_hyperlink";

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ImageRegistry getImageRegistry() {
        if (theImageRegistry != null) return theImageRegistry;
        ImageRegistry imageRegistry = theImageRegistry = new ImageRegistry(UiDesk.getDisplay());
        // MONITORENTER : imageRegistry
        // MONITOREXIT : imageRegistry
        return theImageRegistry;
    }

    public static Image getImage(String name) {
        ImageDescriptor id;
        Image ret = UiDesk.getImageRegistry().get(name);
        if (ret == null && (id = UiDesk.getImageRegistry().getDescriptor(name)) != null) {
            ret = id.createImage();
        }
        return ret;
    }

    public static Color getColor(String desc) {
        return UiDesk.getColorRegistry().get(desc);
    }

    public static ColorRegistry getColorRegistry() {
        if (theColorRegistry == null) {
            theColorRegistry = new ColorRegistry(UiDesk.getDisplay(), true);
        }
        return theColorRegistry;
    }

    public static FormToolkit getToolkit() {
        if (theToolkit == null) {
            theToolkit = new FormToolkit(UiDesk.getDisplay());
        }
        return theToolkit;
    }

    public static Display getDisplay() {
        if (theDisplay == null && PlatformUI.isWorkbenchRunning()) {
            theDisplay = PlatformUI.getWorkbench().getDisplay();
        }
        if (theDisplay == null) {
            theDisplay = PlatformUI.createDisplay();
        }
        return theDisplay;
    }

    public static void updateFont(String cfgName) {
        FontRegistry fr = JFaceResources.getFontRegistry();
        FontData[] fd = PreferenceConverter.getFontDataArray((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.USER), (String)cfgName);
        fr.put(cfgName, fd);
    }

    public static Font getFont(String cfgName) {
        FontRegistry fr = JFaceResources.getFontRegistry();
        if (!fr.hasValueFor(cfgName)) {
            FontData[] fd = PreferenceConverter.getFontDataArray((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.USER), (String)cfgName);
            fr.put(cfgName, fd);
        }
        return fr.get(cfgName);
    }

    public static Font getFont(String name, int height, int style) {
        String key = String.valueOf(name) + ":" + Integer.toString(height) + ":" + Integer.toString(style);
        FontRegistry fr = JFaceResources.getFontRegistry();
        if (!fr.hasValueFor(key)) {
            FontData[] fd = new FontData[]{new FontData(name, height, style)};
            fr.put(key, fd);
        }
        return fr.get(key);
    }

    public static Cursor getCursor(String name) {
        Cursor ret;
        if (cursors == null) {
            cursors = new HashMap();
        }
        if ((ret = cursors.get(name)) == null && name.equals(CUR_HYPERLINK)) {
            ret = UiDesk.getDisplay().getSystemCursor(21);
            cursors.put(name, ret);
        }
        return ret;
    }

    public static Color getColorFromRGB(String coldesc) {
        String col = StringTool.pad((int)1, (char)'0', (String)coldesc, (int)6);
        if (!UiDesk.getColorRegistry().hasValueFor(col)) {
            RGB rgb;
            try {
                rgb = new RGB(Integer.parseInt(col.substring(0, 2), 16), Integer.parseInt(col.substring(2, 4), 16), Integer.parseInt(col.substring(4, 6), 16));
            }
            catch (NumberFormatException nex) {
                ExHandler.handle((Throwable)nex);
                rgb = new RGB(100, 100, 100);
            }
            UiDesk.getColorRegistry().put(col, rgb);
        }
        return UiDesk.getColorRegistry().get(col);
    }

    public static String createColor(RGB rgb) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(StringTool.pad((int)1, (char)'0', (String)Integer.toHexString(rgb.red), (int)2)).append(StringTool.pad((int)1, (char)'0', (String)Integer.toHexString(rgb.green), (int)2)).append(StringTool.pad((int)1, (char)'0', (String)Integer.toHexString(rgb.blue), (int)2));
            String srgb = sb.toString();
            UiDesk.getColorRegistry().put(srgb, rgb);
            return srgb;
        }
        catch (NumberFormatException nex) {
            UiDesk.getColorRegistry().put("A0A0A0", new RGB(160, 160, 160));
            return "A0A0A0";
        }
    }

    public static Shell getTopShell() {
        return UiDesk.getDisplay().getActiveShell();
    }

    public static void asyncExec(Runnable runnable) {
        Display disp = UiDesk.getDisplay();
        if (!disp.isDisposed()) {
            disp.asyncExec(runnable);
        }
    }

    public static void syncExec(Runnable runnable) {
        UiDesk.getDisplay().syncExec(runnable);
    }
}

