/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.contacts.dialogs.BezugsKontaktAuswahl;
import ch.elexis.core.ui.dialogs.KontaktDetailDialog;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.dialogs.ZusatzAdresseEingabeDialog;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.medication.views.FixMediDisplay;
import ch.elexis.core.ui.util.ListDisplay;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.WidgetFactory;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.controls.ClientCustomTextComposite;
import ch.elexis.core.ui.views.controls.StickerComposite;
import ch.elexis.data.BezugsKontakt;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.Person;
import ch.elexis.data.ZusatzAdresse;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.ViewPart;

public class PatientDetailView
extends ViewPart
implements IUnlockable,
IActivationListener {
    public static final String ID = "at.medevit.elexis.contacts.views.PatientDetail";
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private static final String FIXMEDIKATION = Messages.Patientenblatt2_fixmedication;
    private static final String KEY_PATIENTENBLATT = "PatientenDetailView/";
    private ScrolledForm scrldfrm;
    private ViewMenus viewmenu;
    private Text txtDiagnosen;
    private Text txtAnamnese;
    private Text txtFamAnamnese;
    private Text txtAllergien;
    private Text txtRisiken;
    private Text txtBemerkungen;
    private ClientCustomTextComposite compClientCustomText;
    private StickerComposite stickerComposite;
    private IAction removeZAAction;
    private IAction showZAAction;
    private IAction showBKAction;
    private IAction removeAdditionalAddressAction;
    private IAction showAdditionalAddressAction;
    private ListDisplay<BezugsKontakt> inpZusatzAdresse;
    private ListDisplay<ZusatzAdresse> additionalAddresses;
    private IObservableValue patientObservable = new WritableValue(null, Patient.class);
    private boolean bLocked = true;
    private ElexisEventListener eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        public void runInUi(ElexisEvent ev) {
            Patient pat = (Patient)ev.getObject();
            switch (ev.getType()) {
                case 16: {
                    IPersistentObject deselected = (IPersistentObject)PatientDetailView.this.patientObservable.getValue();
                    PatientDetailView.this.setPatient(pat);
                    PatientDetailView.this.releaseAndRefreshLock(deselected, "ch.elexis.core.ui.command.ToggleCurrentPatientLockCommand");
                    break;
                }
                case 4096: 
                case 16384: {
                    if (!pat.equals(PatientDetailView.this.patientObservable.getValue())) break;
                    PatientDetailView.this.setUnlocked(ev.getType() == 4096);
                    break;
                }
            }
        }
    };
    private FixMediDisplay dmd;
    private DataBindingContext bindingContext;

    private void releaseAndRefreshLock(IPersistentObject object, String commandId) {
        if (object != null && LocalLockServiceHolder.get().isLockedLocal((Object)object)) {
            LocalLockServiceHolder.get().releaseLock((Object)object);
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        commandService.refreshElements(commandId, null);
    }

    public PatientDetailView() {
        this.toolkit.setBorderStyle(0);
        this.makeActions();
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat});
    }

    public void setUnlocked(boolean unlocked) {
        this.bLocked = !unlocked;
        this.txtDiagnosen.setEditable(unlocked);
        this.txtAnamnese.setEditable(unlocked);
        this.txtFamAnamnese.setEditable(unlocked);
        this.txtAllergien.setEditable(unlocked);
        this.txtRisiken.setEditable(unlocked);
        this.txtBemerkungen.setEditable(unlocked);
        this.dmd.setUnlocked(unlocked);
        this.inpZusatzAdresse.setUnlocked(unlocked);
        this.additionalAddresses.setUnlocked(unlocked);
        this.removeAdditionalAddressAction.setEnabled(unlocked);
        this.removeZAAction.setEnabled(unlocked);
    }

    void setPatient(Patient p) {
        this.patientObservable.setValue((Object)p);
        this.scrldfrm.setText(String.valueOf(StringTool.unNull((String)p.getName())) + " " + StringTool.unNull((String)p.getVorname()) + " (" + p.getPatCode() + ")");
        this.compClientCustomText.updateClientCustomArea();
        this.stickerComposite.setPatient((IPatient)CoreModelServiceHolder.get().load(p.getId(), IPatient.class).orElse(null));
        this.inpZusatzAdresse.clear();
        for (BezugsKontakt za : p.getBezugsKontakte()) {
            this.inpZusatzAdresse.add((Object)za);
        }
        this.additionalAddresses.clear();
        for (ZusatzAdresse zusatzAdresse : p.getZusatzAdressen()) {
            this.additionalAddresses.add((Object)zusatzAdresse);
        }
        this.dmd.reload();
        this.scrldfrm.reflow(true);
        this.setUnlocked(LocalLockServiceHolder.get().isLockedLocal((Object)p));
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.scrldfrm = this.toolkit.createScrolledForm(parent);
        this.scrldfrm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableWrapLayout td = new TableWrapLayout();
        this.scrldfrm.setText(Messages.Patientenblatt2_noPatientSelected);
        this.scrldfrm.getBody().setLayout((Layout)td);
        Composite scrldfrmComposite = this.scrldfrm.getBody();
        this.compClientCustomText = new ClientCustomTextComposite(this.scrldfrm.getBody(), 0, this.toolkit, this.scrldfrm);
        this.stickerComposite = new StickerComposite(this.scrldfrm.getBody(), 0, this.toolkit);
        ExpandableComposite ecZA = WidgetFactory.createExpandableComposite((FormToolkit)this.toolkit, (ScrolledForm)this.scrldfrm, (String)Messages.Patientenblatt2_contactForAdditionalAddress);
        ecZA.setExpanded(CoreHub.localCfg.get(KEY_PATIENTENBLATT + ecZA.getText(), false));
        ecZA.addExpansionListener((IExpansionListener)new SectionExpansionHandler());
        this.inpZusatzAdresse = new ListDisplay((Composite)ecZA, 0, new ListDisplay.LDListener(){

            public void hyperlinkActivated(String l) {
                BezugsKontaktAuswahl bza;
                Kontakt k;
                Patient sp = ElexisEventDispatcher.getSelectedPatient();
                if (sp == null) {
                    return;
                }
                String[] sortFields = new String[]{"Bezeichnung1", "Bezeichnung2", "Strasse"};
                KontaktSelektor ksl = new KontaktSelektor(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Kontakt.class, Messages.Patientenblatt2_contactForAdditionalAddress, Messages.Patientenblatt2_pleaseSelectardress, sortFields);
                if (ksl.open() == 0 && (k = (Kontakt)ksl.getSelection()) != null && (bza = new BezugsKontaktAuswahl(sp.getLabel(true), k.istPerson() ? Person.load((String)k.getId()).getLabel(true) : k.getLabel(true))).open() == 0 && sp != null) {
                    BezugsKontakt bk = sp.addBezugsKontakt(k, bza.getBezugKonkaktRelation());
                    PatientDetailView.this.inpZusatzAdresse.add((Object)bk);
                    PatientDetailView.this.scrldfrm.reflow(true);
                }
            }

            public String getLabel(Object o) {
                BezugsKontakt bezugsKontakt = (BezugsKontakt)o;
                StringBuffer sb = new StringBuffer();
                sb.append(bezugsKontakt.getLabel());
                Kontakt other = Kontakt.load((String)bezugsKontakt.get("otherID"));
                if (other.exists()) {
                    ArrayList<String> tokens = new ArrayList<String>();
                    String telefon1 = other.get("Telefon1");
                    String telefon2 = other.get("Telefon2");
                    String mobile = other.get("NatelNr");
                    String eMail = other.get("E-Mail");
                    String fax = other.get("Fax");
                    if (!StringTool.isNothing((Object)telefon1)) {
                        tokens.add("T1: " + telefon1);
                    }
                    if (!StringTool.isNothing((Object)telefon2)) {
                        tokens.add("T2: " + telefon2);
                    }
                    if (!StringTool.isNothing((Object)mobile)) {
                        tokens.add("M: " + mobile);
                    }
                    if (!StringTool.isNothing((Object)fax)) {
                        tokens.add("F: " + fax);
                    }
                    if (!StringTool.isNothing((Object)eMail)) {
                        tokens.add(eMail);
                    }
                    for (String token : tokens) {
                        sb.append(", ");
                        sb.append(token);
                    }
                    return sb.toString();
                }
                return "?";
            }
        });
        this.inpZusatzAdresse.addHyperlinks(new String[]{Messages.Patientenblatt2_add});
        this.inpZusatzAdresse.setMenu(new IAction[]{this.removeZAAction, this.showZAAction, this.showBKAction});
        ecZA.setClient(this.inpZusatzAdresse);
        ExpandableComposite compAdditionalAddresses = WidgetFactory.createExpandableComposite((FormToolkit)this.toolkit, (ScrolledForm)this.scrldfrm, (String)Messages.Patientenblatt2_additionalAdresses);
        compAdditionalAddresses.addExpansionListener((IExpansionListener)new SectionExpansionHandler());
        this.additionalAddresses = new ListDisplay((Composite)compAdditionalAddresses, 0, new ListDisplay.LDListener(){

            public void hyperlinkActivated(String l) {
                ZusatzAdresseEingabeDialog aed;
                Patient actPatient = ElexisEventDispatcher.getSelectedPatient();
                if (actPatient != null && (aed = new ZusatzAdresseEingabeDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (Kontakt)actPatient)).open() == 0) {
                    PatientDetailView.this.additionalAddresses.add((Object)aed.getZusatzAdresse());
                    PatientDetailView.this.scrldfrm.reflow(true);
                }
            }

            public String getLabel(Object o) {
                ZusatzAdresse address = (ZusatzAdresse)o;
                if (address != null) {
                    return address.getLabel();
                }
                return "?";
            }
        });
        this.additionalAddresses.addHyperlinks(new String[]{Messages.Patientenblatt2_add});
        this.makeAdditionalAddressActions();
        this.additionalAddresses.setMenu(new IAction[]{this.removeAdditionalAddressAction, this.showAdditionalAddressAction});
        compAdditionalAddresses.setClient(this.additionalAddresses);
        Section sectDiagnosen = this.toolkit.createSection(scrldfrmComposite, 66);
        TableWrapData twd_sectDiagnosen = new TableWrapData(2, 16, 1, 1);
        twd_sectDiagnosen.grabHorizontal = true;
        twd_sectDiagnosen.valign = 128;
        twd_sectDiagnosen.align = 128;
        sectDiagnosen.setLayoutData((Object)twd_sectDiagnosen);
        sectDiagnosen.setText("Diagnosen");
        sectDiagnosen.setExpanded(CoreHub.localCfg.get(KEY_PATIENTENBLATT + sectDiagnosen.getText(), false));
        this.txtDiagnosen = this.toolkit.createText((Composite)sectDiagnosen, "", 66);
        this.txtDiagnosen.addListener(24, (Listener)new MultiLineAutoGrowListener(this.txtDiagnosen));
        sectDiagnosen.setClient((Control)this.txtDiagnosen);
        sectDiagnosen.addExpansionListener((IExpansionListener)new SectionExpansionHandler());
        Section sectAnamnese = this.toolkit.createSection(scrldfrmComposite, 66);
        twd_sectDiagnosen = new TableWrapData(2, 16, 1, 1);
        twd_sectDiagnosen.grabHorizontal = true;
        twd_sectDiagnosen.align = 128;
        sectAnamnese.setLayoutData((Object)twd_sectDiagnosen);
        sectAnamnese.setText("Pers\u00f6nliche Anamnese");
        sectAnamnese.setExpanded(CoreHub.localCfg.get(KEY_PATIENTENBLATT + sectAnamnese.getText(), false));
        this.txtAnamnese = this.toolkit.createText((Composite)sectAnamnese, "", 66);
        this.txtAnamnese.addListener(24, (Listener)new MultiLineAutoGrowListener(this.txtAnamnese));
        sectAnamnese.setClient((Control)this.txtAnamnese);
        sectAnamnese.addExpansionListener((IExpansionListener)new SectionExpansionHandler());
        Section sectFamAnamnese = this.toolkit.createSection(scrldfrmComposite, 66);
        twd_sectDiagnosen = new TableWrapData(2, 16, 1, 1);
        twd_sectDiagnosen.grabHorizontal = true;
        twd_sectDiagnosen.align = 128;
        sectFamAnamnese.setLayoutData((Object)twd_sectDiagnosen);
        sectFamAnamnese.setText("Familien-Anamnese");
        sectFamAnamnese.setExpanded(CoreHub.localCfg.get(KEY_PATIENTENBLATT + sectFamAnamnese.getText(), false));
        this.txtFamAnamnese = this.toolkit.createText((Composite)sectFamAnamnese, "", 66);
        this.txtFamAnamnese.setText("");
        this.txtFamAnamnese.addListener(24, (Listener)new MultiLineAutoGrowListener(this.txtFamAnamnese));
        sectFamAnamnese.setClient((Control)this.txtFamAnamnese);
        sectFamAnamnese.addExpansionListener((IExpansionListener)new SectionExpansionHandler());
        Section sectAllergien = this.toolkit.createSection(scrldfrmComposite, 66);
        twd_sectDiagnosen = new TableWrapData(2, 16, 1, 1);
        twd_sectDiagnosen.grabHorizontal = true;
        twd_sectDiagnosen.align = 128;
        sectAllergien.setLayoutData((Object)twd_sectDiagnosen);
        sectAllergien.setText("Allergien");
        sectAllergien.setExpanded(CoreHub.localCfg.get(KEY_PATIENTENBLATT + sectAllergien.getText(), false));
        this.txtAllergien = this.toolkit.createText((Composite)sectAllergien, "", 66);
        this.txtAllergien.setText("");
        this.txtAllergien.addListener(24, (Listener)new MultiLineAutoGrowListener(this.txtAllergien));
        sectAllergien.setClient((Control)this.txtAllergien);
        sectAllergien.addExpansionListener((IExpansionListener)new SectionExpansionHandler());
        Section sectRisiken = this.toolkit.createSection(scrldfrmComposite, 66);
        twd_sectDiagnosen = new TableWrapData(2, 16, 1, 1);
        twd_sectDiagnosen.grabHorizontal = true;
        twd_sectDiagnosen.align = 128;
        sectRisiken.setLayoutData((Object)twd_sectDiagnosen);
        sectRisiken.setText("Risiken");
        sectRisiken.setExpanded(CoreHub.localCfg.get(KEY_PATIENTENBLATT + sectRisiken.getText(), false));
        this.txtRisiken = this.toolkit.createText((Composite)sectRisiken, "", 66);
        this.txtRisiken.setText("");
        this.txtRisiken.addListener(24, (Listener)new MultiLineAutoGrowListener(this.txtRisiken));
        sectRisiken.setClient((Control)this.txtRisiken);
        sectRisiken.addExpansionListener((IExpansionListener)new SectionExpansionHandler());
        Section sectBemerkungen = this.toolkit.createSection(scrldfrmComposite, 66);
        twd_sectDiagnosen = new TableWrapData(2, 16, 1, 1);
        twd_sectDiagnosen.grabHorizontal = true;
        twd_sectDiagnosen.align = 128;
        sectBemerkungen.setLayoutData((Object)twd_sectDiagnosen);
        sectBemerkungen.setText("Bemerkungen");
        sectBemerkungen.setExpanded(CoreHub.localCfg.get(KEY_PATIENTENBLATT + sectBemerkungen.getText(), false));
        this.txtBemerkungen = this.toolkit.createText((Composite)sectBemerkungen, "", 66);
        this.txtBemerkungen.setText("");
        this.txtBemerkungen.addListener(24, (Listener)new MultiLineAutoGrowListener(this.txtBemerkungen));
        sectBemerkungen.setClient((Control)this.txtBemerkungen);
        sectBemerkungen.addExpansionListener((IExpansionListener)new SectionExpansionHandler());
        ExpandableComposite ecdm = WidgetFactory.createExpandableComposite((FormToolkit)this.toolkit, (ScrolledForm)this.scrldfrm, (String)FIXMEDIKATION);
        ecdm.addExpansionListener((IExpansionListener)new SectionExpansionHandler());
        this.dmd = new FixMediDisplay((Composite)ecdm, this.getViewSite());
        ecdm.setClient((Control)this.dmd);
        this.viewmenu = new ViewMenus(this.getViewSite());
        this.viewmenu.createMenu(new IAction[]{GlobalActions.printEtikette, GlobalActions.printAdresse, GlobalActions.printBlatt, GlobalActions.printRoeBlatt});
        this.initDataBindings();
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat});
        this.toolkit.dispose();
        super.dispose();
    }

    public void setFocus() {
        Patient p;
        if (this.patientObservable.getValue() == null && (p = ElexisEventDispatcher.getSelectedPatient()) != null) {
            this.setPatient(p);
        }
    }

    private void refreshUi() {
        this.bindingContext.updateTargets();
    }

    protected void initDataBindings() {
        this.bindingContext = new DataBindingContext();
        Text[] control = new Text[]{this.txtAllergien, this.txtAnamnese, this.txtBemerkungen, this.txtDiagnosen, this.txtRisiken, this.txtFamAnamnese};
        String[] property = new String[]{"allergies", "personalAnamnese", "comment", "diagnosen", "risk", "familyAnamnese"};
        int i = 0;
        while (i < control.length) {
            this.bindValue(control[i], property[i], this.bindingContext);
            ++i;
        }
    }

    private void bindValue(Text text, String property, DataBindingContext bindingContext) {
        ISWTObservableValue textObserveWidget = SWTObservables.observeDelayedValue((int)5, (ISWTObservableValue)SWTObservables.observeText((Control)text, (int)24));
        IObservableValue observeValue = PojoObservables.observeDetailValue((IObservableValue)this.patientObservable, (String)property, String.class);
        bindingContext.bindValue((IObservableValue)textObserveWidget, observeValue, null, null);
    }

    private void makeActions() {
        this.removeZAAction = new Action(Messages.Patientenblatt2_removeAddress){

            public void run() {
                BezugsKontakt a = (BezugsKontakt)PatientDetailView.this.inpZusatzAdresse.getSelection();
                a.delete();
                PatientDetailView.this.setPatient(ElexisEventDispatcher.getSelectedPatient());
            }
        };
        this.showZAAction = new RestrictedAction(AccessControlDefaults.PATIENT_DISPLAY, Messages.Patientenblatt2_showAddress){

            public void doRun() {
                Kontakt a = Kontakt.load((String)((BezugsKontakt)PatientDetailView.this.inpZusatzAdresse.getSelection()).get("otherID"));
                KontaktDetailDialog kdd = new KontaktDetailDialog(PatientDetailView.this.scrldfrm.getShell(), a, PatientDetailView.this.bLocked);
                if (kdd.open() == 0) {
                    PatientDetailView.this.setPatient(ElexisEventDispatcher.getSelectedPatient());
                }
            }
        };
        this.showBKAction = new RestrictedAction(AccessControlDefaults.PATIENT_DISPLAY, Messages.Patientenblatt2_showBezugKontaktRelation){

            public void doRun() {
                BezugsKontakt bezugsKontakt;
                Patient actPatient = ElexisEventDispatcher.getSelectedPatient();
                if (actPatient != null && actPatient.exists() && (bezugsKontakt = (BezugsKontakt)PatientDetailView.this.inpZusatzAdresse.getSelection()) != null) {
                    Kontakt k = Kontakt.load((String)bezugsKontakt.get("otherID"));
                    BezugsKontaktAuswahl bza = new BezugsKontaktAuswahl(actPatient.getLabel(true), k.istPerson() ? Person.load((String)k.getId()).getLabel(true) : k.getLabel(true), bezugsKontakt, PatientDetailView.this.bLocked);
                    if (bezugsKontakt != null && bza.open() == 0 && bza.getBezugKonkaktRelation() != null) {
                        bezugsKontakt.updateRelation(bza.getBezugKonkaktRelation());
                        PatientDetailView.this.setPatient(actPatient);
                    }
                }
            }
        };
    }

    private void makeAdditionalAddressActions() {
        this.removeAdditionalAddressAction = new Action(Messages.Patientenblatt2_removeAddress){

            public void run() {
                ZusatzAdresse a = (ZusatzAdresse)PatientDetailView.this.additionalAddresses.getSelection();
                a.delete();
                PatientDetailView.this.setPatient(ElexisEventDispatcher.getSelectedPatient());
            }
        };
        this.showAdditionalAddressAction = new Action(Messages.Patientenblatt2_showAddress){

            public void run() {
                Patient actPatient = ElexisEventDispatcher.getSelectedPatient();
                ZusatzAdresse zusatzAdresse = (ZusatzAdresse)PatientDetailView.this.additionalAddresses.getSelection();
                ZusatzAdresseEingabeDialog aed = new ZusatzAdresseEingabeDialog(PatientDetailView.this.scrldfrm.getShell(), (Kontakt)actPatient, zusatzAdresse, PatientDetailView.this.bLocked);
                if (aed.open() == 0) {
                    PatientDetailView.this.setPatient(actPatient);
                }
            }
        };
    }

    public void activation(boolean mode) {
        if (mode) {
            this.refreshUi();
        }
    }

    public void visible(boolean mode) {
    }

    private final class MultiLineAutoGrowListener
    implements Listener {
        protected int lines = 0;
        private Text t;

        public MultiLineAutoGrowListener(Text t) {
            this.t = t;
        }

        public void handleEvent(Event event) {
            if (event.type != 24) {
                return;
            }
            if (this.t.getLineCount() != this.lines) {
                this.lines = this.t.getLineCount();
                this.t.setSize(this.t.getSize().x, this.lines * (int)this.t.getFont().getFontData()[0].height);
                PatientDetailView.this.scrldfrm.reflow(true);
            }
        }
    }

    private final class SectionExpansionHandler
    extends ExpansionAdapter {
        private SectionExpansionHandler() {
        }

        public void expansionStateChanged(ExpansionEvent e) {
            ExpandableComposite src = (ExpandableComposite)e.getSource();
            CoreHub.localCfg.set(PatientDetailView.KEY_PATIENTENBLATT + src.getText(), src.isExpanded());
            PatientDetailView.this.scrldfrm.reflow(true);
        }
    }
}

