/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.ui.actions.FlatDataLoader;
import ch.elexis.core.ui.actions.PersistentObjectLoader;
import ch.elexis.core.ui.contacts.views.KontaktDetailView;
import ch.elexis.core.ui.dialogs.GenericPrintDialog;
import ch.elexis.core.ui.dialogs.KontaktErfassenDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.LockedRestrictedAction;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Organisation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.rgw.tools.StringTool;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class KontakteView
extends ViewPart
implements ViewerConfigurer.ControlFieldListener {
    public static final String ID = "ch.elexis.Kontakte";
    private CommonViewer cv;
    private ViewerConfigurer vc;
    IAction dupKontakt;
    IAction delKontakt;
    IAction createKontakt;
    IAction printList;
    PersistentObjectLoader loader;
    private final String[] fields = new String[]{"Kuerzel=" + Messages.KontakteView_shortLabel, "Bezeichnung1=" + Messages.KontakteView_text1, "Bezeichnung2=" + Messages.KontakteView_text2, "Strasse=" + Messages.KontakteView_street, "Plz=" + Messages.KontakteView_zip, "Ort=" + Messages.KontakteView_place};
    private ViewMenus menu;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.cv = new CommonViewer();
        this.loader = new FlatDataLoader(this.cv, new Query(Kontakt.class));
        this.loader.setOrderFields(new String[]{"Bezeichnung1", "Bezeichnung2", "Strasse", "Ort"});
        this.vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)this.loader, (LabelProvider)new KontaktLabelProvider(), (ViewerConfigurer.ControlFieldProvider)new DefaultControlFieldProvider(this.cv, this.fields), (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(3, 2, null));
        this.cv.create(this.vc, parent, 0, (Object)this.getViewSite());
        this.makeActions();
        this.cv.setObjectCreateAction(this.getViewSite(), this.createKontakt);
        this.menu = new ViewMenus(this.getViewSite());
        this.menu.createViewerContextMenu(this.cv.getViewerWidget(), new IAction[]{this.delKontakt, this.dupKontakt});
        this.menu.createMenu(new IAction[]{this.printList});
        this.menu.createToolbar(new IAction[]{this.printList});
        this.vc.getContentProvider().startListening();
        this.vc.getControlFieldProvider().addChangeListener((ViewerConfigurer.ControlFieldListener)this);
        this.cv.addDoubleClickListener(new CommonViewer.PoDoubleClickListener(){

            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                try {
                    KontaktDetailView kdv = (KontaktDetailView)KontakteView.this.getSite().getPage().showView("ch.elexis.KontaktDetailView");
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)obj);
                }
                catch (PartInitException e) {
                    ElexisStatus es = new ElexisStatus(4, "ch.elexis.core.ui.contacts", 0, "Fehler beim \u00d6ffnen", (Exception)((Object)e));
                    ElexisEventDispatcher.fireElexisStatusEvent((ElexisStatus)es);
                }
            }
        });
    }

    public void dispose() {
        this.vc.getContentProvider().stopListening();
        this.vc.getControlFieldProvider().removeChangeListener((ViewerConfigurer.ControlFieldListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.vc.getControlFieldProvider().setFocus();
    }

    public void changed(HashMap<String, String> values) {
        ElexisEventDispatcher.clearSelection(Kontakt.class);
    }

    public void reorder(String field) {
        this.loader.reorder(field);
    }

    public void selected() {
        Object element;
        StructuredViewer viewer = this.cv.getViewerWidget();
        Object[] elements = this.cv.getConfigurer().getContentProvider().getElements(viewer.getInput());
        if (elements != null && elements.length > 0 && (element = elements[0]) instanceof PersistentObject) {
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((PersistentObject)element));
        }
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    private void makeActions() {
        this.delKontakt = new LockedRestrictedAction<Kontakt>(AccessControlDefaults.KONTAKT_DELETE, Messages.KontakteView_delete){

            public void doRun(Kontakt k) {
                if (SWTHelper.askYesNo((String)"Wirklich l\u00f6schen?", (String)k.getLabel())) {
                    k.delete();
                    KontakteView.this.cv.getConfigurer().getControlFieldProvider().fireChangedEvent();
                }
            }

            public Kontakt getTargetedObject() {
                return (Kontakt)KontakteView.this.cv.getViewerWidgetFirstSelection();
            }
        };
        this.dupKontakt = new Action(Messages.KontakteView_duplicate){

            public void run() {
                Object[] o = KontakteView.this.cv.getSelection();
                if (o != null) {
                    Organisation dup;
                    Kontakt k = (Kontakt)o[0];
                    if (k.istPerson()) {
                        Person p = Person.load((String)k.getId());
                        dup = new Person(p.getName(), p.getVorname(), p.getGeburtsdatum(), p.getGeschlecht());
                    } else {
                        Organisation org = Organisation.load((String)k.getId());
                        dup = new Organisation(org.get("Bezeichnung1"), org.get("Bezeichnung2"));
                    }
                    dup.setAnschrift(k.getAnschrift());
                    KontakteView.this.cv.getConfigurer().getControlFieldProvider().fireChangedEvent();
                }
            }
        };
        this.createKontakt = new Action(Messages.KontakteView_create){

            public void run() {
                String[] flds = KontakteView.this.cv.getConfigurer().getControlFieldProvider().getValues();
                String[] predef = new String[]{flds[1], flds[2], "", flds[3], flds[4], flds[5]};
                KontaktErfassenDialog ked = new KontaktErfassenDialog(KontakteView.this.getViewSite().getShell(), predef);
                ked.open();
            }
        };
        this.printList = new Action("Markierte Adressen drucken"){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText("Die in der Liste markierten Kontakte als Tabelle ausdrucken");
            }

            public void run() {
                Object[] sel = KontakteView.this.cv.getSelection();
                String[][] adrs = new String[sel.length][];
                if (sel != null && sel.length > 0) {
                    GenericPrintDialog gpl = new GenericPrintDialog(KontakteView.this.getViewSite().getShell(), "Adressliste", "Adressliste");
                    gpl.create();
                    int i = 0;
                    while (i < sel.length) {
                        Kontakt k = (Kontakt)sel[i];
                        String[] f = new String[]{"Bezeichnung1", "Bezeichnung2", "Bezeichnung3", "Strasse", "Plz", "Ort", "Telefon1"};
                        String[] v = new String[f.length];
                        k.get(f, v);
                        adrs[i] = new String[4];
                        adrs[i][0] = v[0] + " " + v[1] + " " + v[2];
                        adrs[i][1] = v[3];
                        adrs[i][2] = v[4] + " " + v[5];
                        adrs[i][3] = v[6];
                        ++i;
                    }
                    gpl.insertTable("[Liste]", adrs, null);
                    gpl.open();
                }
            }
        };
    }

    class KontaktLabelProvider
    extends DefaultLabelProvider {
        KontaktLabelProvider() {
        }

        public String getText(Object element) {
            String[] fields = new String[]{"Bezeichnung1", "Bezeichnung2", "Bezeichnung3", "Strasse", "Plz", "Ort", "Telefon1"};
            String[] values = new String[fields.length];
            ((Kontakt)element).get(fields, values);
            return StringTool.join((String[])values, (String)",");
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

