/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.extension;

import ch.elexis.core.types.Country;
import ch.elexis.core.ui.contacts.interfaces.IContactGenoameService;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactGeonamesExtensionPoint {
    private static final String EXT_POINT = "ch.elexis.core.ui.contacts.geonames";
    private static Logger log = LoggerFactory.getLogger(ContactGeonamesExtensionPoint.class);
    private static HashMap<Country, IContactGenoameService> services = new HashMap();

    public static void init() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_POINT);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ice = iConfigurationElementArray[n2];
            try {
                Object o = ice.createExecutableExtension("geonames");
                if (o instanceof IContactGenoameService) {
                    IContactGenoameService cgs = (IContactGenoameService)o;
                    log.debug("IContactGenoameService found @ " + ice.getContributor().getName() + ": " + o.getClass().getName());
                    services.put(cgs.getProvidesInformationForCountry(), cgs);
                }
                return;
            }
            catch (CoreException ex) {
                log.error("Error at IContactGenoameService extension initialization", (Throwable)ex);
                ++n2;
            }
        }
    }

    public static IContactGenoameService getGeonameServiceForCountry(Country country) {
        return services.get(country);
    }
}

