/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.handlers;

import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import java.time.LocalDateTime;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class SetAsSymptomaticMedicationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MedicationTableViewerItem mtvItem;
        IPrescription presc;
        IStructuredSelection strucSelection;
        Object firstElement;
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && (firstElement = (strucSelection = (IStructuredSelection)selection).getFirstElement()) instanceof MedicationTableViewerItem && (presc = (mtvItem = (MedicationTableViewerItem)firstElement).getPrescription()) != null && presc.getEntryType() != EntryType.SYMPTOMATIC_MEDICATION) {
            AcquireLockUi.aquireAndRun((Identifiable)presc, (ILockHandler)new ILockHandler(){

                public void lockFailed() {
                }

                public void lockAcquired() {
                    IPrescription symptomaticMedi = MedicationServiceHolder.get().createPrescriptionCopy(presc);
                    symptomaticMedi.setEntryType(EntryType.SYMPTOMATIC_MEDICATION);
                    CoreModelServiceHolder.get().save((Identifiable)symptomaticMedi);
                    MedicationServiceHolder.get().stopPrescription(presc, LocalDateTime.now(), "Umgestellt auf Symtomatische Medikation");
                    CoreModelServiceHolder.get().save((Identifiable)presc);
                }
            });
            ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)presc);
        }
        return null;
    }
}

