/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.handlers;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class MentionInConsultationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && !selection.isEmpty()) {
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            ArrayList<IPrescription> prescriptions = new ArrayList<IPrescription>();
            List mtvItems = strucSelection.toList();
            for (MedicationTableViewerItem mtvItem : mtvItems) {
                IPrescription p = mtvItem.getPrescription();
                if (p == null) continue;
                prescriptions.add(p);
            }
            if (!prescriptions.isEmpty()) {
                IPatient patient = ((IPrescription)prescriptions.get(0)).getPatient();
                Optional encounter = EncounterServiceHolder.get().getLatestEncounter(patient);
                encounter.ifPresent(enc -> {
                    StringBuilder sb = new StringBuilder();
                    for (IPrescription presc : prescriptions) {
                        String articleLabel = "";
                        if (presc.getArticle() != null) {
                            articleLabel = presc.getArticle().getLabel();
                        }
                        sb.append("\n");
                        sb.append("Medikation: " + articleLabel + ", " + presc.getDosageInstruction() + " " + this.getType(presc.getEntryType()));
                    }
                    Samdas samdas = new Samdas(enc.getVersionedEntry().getHead());
                    Samdas.Record rec = samdas.getRecord();
                    String recText = rec.getText();
                    recText = String.valueOf(recText) + sb.toString();
                    rec.setText(recText);
                    EncounterServiceHolder.get().updateVersionedEntry(enc, samdas);
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", enc);
                });
            }
        }
        return null;
    }

    private String getType(EntryType entryType) {
        switch (entryType) {
            case FIXED_MEDICATION: {
                return "(Fixmedikation)";
            }
            case RESERVE_MEDICATION: {
                return "(Reservemedikation)";
            }
            case SELF_DISPENSED: {
                return "(Dispensiert)";
            }
            case RECIPE: {
                return "(Rezeptiert)";
            }
        }
        return "";
    }
}

