/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.types;

import ch.elexis.core.jdt.Nullable;

public enum LabItemTyp {
    NUMERIC(0),
    TEXT(1),
    ABSOLUTE(2),
    FORMULA(3),
    DOCUMENT(4);

    private int type;

    private LabItemTyp(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    @Nullable
    public static LabItemTyp fromType(int type) {
        LabItemTyp[] labItemTypArray = LabItemTyp.values();
        int n = labItemTypArray.length;
        int n2 = 0;
        while (n2 < n) {
            LabItemTyp lit = labItemTypArray[n2];
            if (type == lit.getType()) {
                return lit;
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    public static LabItemTyp fromType(String type) {
        try {
            int parseInt = Integer.parseInt(type);
            return LabItemTyp.fromType(parseInt);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

