/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.builder;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.builder.AbstractBuilder;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import java.time.LocalDateTime;

public class IPrescriptionBuilder
extends AbstractBuilder<IPrescription> {
    public IPrescriptionBuilder(IModelService modelService, IContextService context, IArticle article, IPatient patient, String dosageInstruction) {
        super(modelService);
        this.object = modelService.create(IPrescription.class);
        ((IPrescription)this.object).setDateFrom(LocalDateTime.now());
        ((IPrescription)this.object).setPatient(patient);
        ((IPrescription)this.object).setArticle(article);
        ((IPrescription)this.object).setDosageInstruction(dosageInstruction);
        ((IPrescription)this.object).setEntryType(EntryType.FIXED_MEDICATION);
        if (context != null) {
            ((IPrescription)this.object).setPrescriptor(context.getActiveUserContact().orElse(null));
        }
    }

    public IPrescriptionBuilder entryType(EntryType entryType) {
        ((IPrescription)this.object).setEntryType(entryType);
        return this;
    }

    public IPrescriptionBuilder remark(String remark) {
        ((IPrescription)this.object).setRemark(remark);
        return this;
    }
}

