/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.eigendiagnosen.model.service;

import ch.elexis.core.eigendiagnosen.model.service.ModelUtil;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IDiagnosisTree;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class CodeElementContribution
implements ICodeElementServiceContribution {
    @Reference(target="(service.model.name=ch.elexis.core.eigendiagnosen.model)")
    private IModelService modelService;

    public String getSystem() {
        return "ED";
    }

    public ICodeElementService.CodeElementTyp getTyp() {
        return ICodeElementService.CodeElementTyp.DIAGNOSE;
    }

    public Optional<ICodeElement> loadFromCode(String code, Map<Object, Object> context) {
        return ModelUtil.loadDiagnosisWithCode(code);
    }

    public List<ICodeElement> getElements(Map<Object, Object> context) {
        IQuery query = this.modelService.getQuery(IDiagnosisTree.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IDIAGNOSIS_TREE__PARENT, IQuery.COMPARATOR.NOT_EQUALS, null);
        return query.execute();
    }
}

