/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.preference;

import ch.elexis.core.mail.MailAccount;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import java.util.ArrayList;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MailAccountComposite
extends Composite {
    private WritableValue<MailAccount> value;
    private DataBindingContext context;
    private Label fromAddressLabel;
    private Text fromAddress;
    private WritableList<Mandant> mandantInput;
    private Text txtPort;
    private Text txtHost;
    private Text txtPassword;
    private Text txtUsername;
    private Text txtId;

    public MailAccountComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent();
    }

    private void createContent() {
        this.value = new WritableValue();
        this.context = new DataBindingContext();
        this.setLayout((Layout)new GridLayout(2, false));
        Label lbl = new Label((Composite)this, 0);
        lbl.setText("ID");
        this.txtId = new Text((Composite)this, 2048);
        this.txtId.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)this.txtId);
        IObservableValue model = PojoProperties.value((String)"id", MailAccount.class).observeDetail(this.value);
        UpdateValueStrategy targetToModel = new UpdateValueStrategy();
        targetToModel.setAfterGetValidator(o1 -> {
            String s = (String)o1;
            if (s != null && !s.isEmpty()) {
                return ValidationStatus.ok();
            }
            return ValidationStatus.error((String)"");
        });
        Binding binding = this.context.bindValue((IObservableValue)target, model, targetToModel, null);
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512);
        lbl = new Label((Composite)this, 0);
        lbl.setText("Typ");
        final ComboViewer typeViewer = new ComboViewer((Composite)this, 4);
        typeViewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        typeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        typeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                MailAccount.TYPE type = (MailAccount.TYPE)element;
                if (type == MailAccount.TYPE.IMAP) {
                    return "Eingehend (" + type.name() + ")";
                }
                if (type == MailAccount.TYPE.IMAPS) {
                    return "Ausgehend (IMAP over SSL)";
                }
                if (type == MailAccount.TYPE.SMTP) {
                    return "Ausgehend (" + type.name() + ")";
                }
                return ((MailAccount.TYPE)element).name();
            }
        });
        typeViewer.setInput((Object)MailAccount.TYPE.values());
        IViewerObservableValue viewerTarget = ViewerProperties.singleSelection().observe((Viewer)typeViewer);
        model = PojoProperties.value((String)"type", MailAccount.class).observeDetail(this.value);
        this.context.bindValue((IObservableValue)viewerTarget, model);
        typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MailAccount.TYPE type = (MailAccount.TYPE)typeViewer.getStructuredSelection().getFirstElement();
                if (type != null) {
                    switch (type) {
                        case IMAP: {
                            MailAccountComposite.this.txtPort.setText("143");
                            break;
                        }
                        case IMAPS: {
                            MailAccountComposite.this.txtPort.setText("993");
                            break;
                        }
                        case SMTP: {
                            MailAccountComposite.this.txtPort.setText("25");
                            break;
                        }
                    }
                }
                MailAccountComposite.this.updateUi();
            }
        });
        lbl = new Label((Composite)this, 0);
        lbl.setText("Username");
        this.txtUsername = new Text((Composite)this, 2048);
        this.txtUsername.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        target = WidgetProperties.text((int)24).observe((Widget)this.txtUsername);
        model = PojoProperties.value((String)"username", MailAccount.class).observeDetail(this.value);
        this.context.bindValue((IObservableValue)target, model);
        lbl = new Label((Composite)this, 0);
        lbl.setText("Password");
        this.txtPassword = new Text((Composite)this, 0x400800);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        target = WidgetProperties.text((int)24).observe((Widget)this.txtPassword);
        model = PojoProperties.value((String)"password", MailAccount.class).observeDetail(this.value);
        this.context.bindValue((IObservableValue)target, model);
        this.fromAddressLabel = new Label((Composite)this, 0);
        this.fromAddressLabel.setText("Von Adresse");
        this.fromAddress = new Text((Composite)this, 2048);
        this.fromAddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        target = WidgetProperties.text((int)24).observe((Widget)this.fromAddress);
        model = PojoProperties.value((String)"from", MailAccount.class).observeDetail(this.value);
        this.context.bindValue((IObservableValue)target, model);
        lbl = new Label((Composite)this, 0);
        lbl.setText("Host");
        this.txtHost = new Text((Composite)this, 2048);
        this.txtHost.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        target = WidgetProperties.text((int)24).observe((Widget)this.txtHost);
        model = PojoProperties.value((String)"host", MailAccount.class).observeDetail(this.value);
        targetToModel = new UpdateValueStrategy();
        targetToModel.setAfterGetValidator(o1 -> {
            String s = (String)o1;
            if (s != null && !s.isEmpty()) {
                return ValidationStatus.ok();
            }
            return ValidationStatus.error((String)"");
        });
        binding = this.context.bindValue((IObservableValue)target, model, targetToModel, null);
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512);
        lbl = new Label((Composite)this, 0);
        lbl.setText("Port");
        this.txtPort = new Text((Composite)this, 2048);
        this.txtPort.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        target = WidgetProperties.text((int)24).observe((Widget)this.txtPort);
        model = PojoProperties.value((String)"port", String.class).observeDetail(this.value);
        targetToModel = new UpdateValueStrategy();
        targetToModel.setAfterGetValidator(o1 -> {
            String s = (String)o1;
            if (s != null && !s.isEmpty()) {
                return ValidationStatus.ok();
            }
            return ValidationStatus.error((String)"");
        });
        binding = this.context.bindValue((IObservableValue)target, model, targetToModel, null);
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512);
        lbl = new Label((Composite)this, 0);
        lbl.setText("Start TLS");
        Button btnStartTls = new Button((Composite)this, 32);
        target = WidgetProperties.buttonSelection().observe((Widget)btnStartTls);
        model = PojoProperties.value((String)"starttls", Boolean.class).observeDetail(this.value);
        this.context.bindValue((IObservableValue)target, model);
        lbl = new Label((Composite)this, 0);
        lbl.setText("Mandanten");
        final TableViewer mandantViewer = new TableViewer((Composite)this, 2048);
        mandantViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.mandantInput = new WritableList(new ArrayList(), Mandant.class);
        ViewerSupport.bind((StructuredViewer)mandantViewer, this.mandantInput, (IValueProperty[])PojoProperties.values((String[])new String[]{"label"}));
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action("hinzuf\u00fcgen"){

            public void run() {
                KontaktSelektor selector = new KontaktSelektor(MailAccountComposite.this.getShell(), Mandant.class, "Mandant auswahl", "Mandanten f\u00fcr das Konto ausw\u00e4hlen", Kontakt.DEFAULT_SORT);
                if (selector.open() == 0) {
                    Mandant selected = (Mandant)selector.getSelection();
                    MailAccountComposite.this.getAccount().addMandant((IMandator)CoreModelServiceHolder.get().load(selected.getId(), IMandator.class).orElse(null));
                    MailAccountComposite.this.updateUi();
                }
            }
        });
        menuManager.add((IAction)new Action("entfernen"){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)mandantViewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    Mandant selected = (Mandant)selection.getFirstElement();
                    MailAccountComposite.this.getAccount().removeMandant((IMandator)CoreModelServiceHolder.get().load(selected.getId(), IMandator.class).orElse(null));
                    MailAccountComposite.this.updateUi();
                }
            }

            public boolean isEnabled() {
                IStructuredSelection selection = (IStructuredSelection)mandantViewer.getSelection();
                return selection != null && !selection.isEmpty();
            }
        });
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] items;
                IContributionItem[] iContributionItemArray = items = manager.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem iContributionItem = iContributionItemArray[n2];
                    iContributionItem.update();
                    ++n2;
                }
            }
        });
        mandantViewer.getControl().setMenu(menuManager.createContextMenu(mandantViewer.getControl()));
    }

    public void setAccount(MailAccount mailAccount) {
        this.value.setValue((Object)mailAccount);
        this.updateUi();
    }

    private void updateUi() {
        MailAccount mailAccount = this.getAccount();
        this.mandantInput.clear();
        if (mailAccount != null) {
            if (mailAccount.getType() == MailAccount.TYPE.IMAP) {
                ((GridData)this.fromAddressLabel.getLayoutData()).exclude = true;
                this.fromAddressLabel.setVisible(false);
                ((GridData)this.fromAddress.getLayoutData()).exclude = true;
                this.fromAddress.setVisible(false);
            } else if (mailAccount.getType() == MailAccount.TYPE.SMTP) {
                ((GridData)this.fromAddressLabel.getLayoutData()).exclude = false;
                this.fromAddressLabel.setVisible(true);
                ((GridData)this.fromAddress.getLayoutData()).exclude = false;
                this.fromAddress.setVisible(true);
            } else {
                ((GridData)this.fromAddressLabel.getLayoutData()).exclude = true;
                this.fromAddressLabel.setVisible(false);
                ((GridData)this.fromAddress.getLayoutData()).exclude = true;
                this.fromAddress.setVisible(false);
            }
            String mandants = mailAccount.getMandants();
            if (mandants != null) {
                String[] ids;
                String[] stringArray = ids = mandants.split("\\|\\|");
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    Mandant mandant = Mandant.load((String)string);
                    if (mandant != null && mandant.exists()) {
                        this.mandantInput.add((Object)mandant);
                    }
                    ++n2;
                }
            }
        }
        this.layout();
        this.redraw();
    }

    public MailAccount getAccount() {
        return (MailAccount)this.value.getValue();
    }
}

