/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.dialogs;

import ch.elexis.core.mail.ui.dialogs.AttachmentsComposite;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.ui.icons.Images;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.LoggerFactory;

public class AddAttachmentAction
extends Action
implements IAction {
    private AttachmentsComposite composite;

    public AddAttachmentAction(AttachmentsComposite attachmentsComposite) {
        this.composite = attachmentsComposite;
    }

    public ImageDescriptor getImageDescriptor() {
        return Images.IMG_NEW.getImageDescriptor();
    }

    public void run() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command openSelectionCommand = commandService.getCommand("ch.elexis.core.ui.documents.commandOpenSelection");
        ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)openSelectionCommand, Collections.emptyMap());
        try {
            Object selection = ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
            if (selection instanceof List) {
                for (Object selected : (List)selection) {
                    if (!(selected instanceof IDocument)) continue;
                    this.composite.addDocument((IDocument)selected);
                }
            }
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error adding document", e);
        }
    }
}

