/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.model.adapter;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractModelAdapterFactory;
import ch.elexis.core.jpa.model.adapter.internal.QueryCursor;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQueryCursor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.slf4j.LoggerFactory;

public class NamedQuery<R, T>
implements INamedQuery<R> {
    private AbstractModelAdapterFactory adapterFactory;
    private Class<T> interfaceClazz;
    private Class<R> returnValueClazz;
    private Class<? extends EntityWithId> entityClazz;
    private TypedQuery<?> query;
    private EntityManager entityManager;

    public NamedQuery(Class<R> returnValueClazz, Class<T> interfaceClazz, boolean refreshCache, AbstractModelAdapterFactory adapterFactory, EntityManager entityManager, String queryName) {
        this.adapterFactory = adapterFactory;
        this.interfaceClazz = interfaceClazz;
        this.returnValueClazz = returnValueClazz;
        this.entityClazz = adapterFactory.getEntityClass(interfaceClazz);
        this.entityManager = entityManager;
        this.query = entityManager.createNamedQuery(queryName, this.entityClazz);
        if (refreshCache) {
            this.query.setHint("eclipselink.refresh", (Object)"True");
        }
    }

    protected Object resolveValue(Object value) {
        Object ret = value;
        if (value instanceof AbstractIdModelAdapter) {
            ret = ((AbstractIdModelAdapter)value).getEntity();
        }
        return ret;
    }

    public List<R> executeWithParameters(Map<String, Object> parameters) {
        parameters.forEach((k, v) -> {
            v = this.resolveValue(v);
            this.query.setParameter(k, v);
        });
        if (this.returnValueClazz.equals(this.interfaceClazz)) {
            List ret = ((Stream)this.query.getResultStream().parallel()).map(e -> this.adapterFactory.getModelAdapter((EntityWithId)e, this.interfaceClazz, true).orElse(null)).filter(o -> o != null).collect(Collectors.toList());
            return ret;
        }
        return this.query.getResultList().parallelStream().filter(r -> r != null).collect(Collectors.toList());
    }

    public IQueryCursor<R> executeAsCursorWithParameters(Map<String, Object> parameters) {
        parameters.forEach((k, v) -> {
            v = this.resolveValue(v);
            this.query.setParameter(k, v);
        });
        this.query.setHint("eclipselink.maintain-cache", (Object)"False");
        this.query.setHint("eclipselink.cursor.scrollable", (Object)"True");
        if (this.returnValueClazz.equals(this.interfaceClazz)) {
            ScrollableCursor cursor = (ScrollableCursor)this.query.getSingleResult();
            return new QueryCursor(cursor, this.adapterFactory, this.interfaceClazz);
        }
        ScrollableCursor cursor = (ScrollableCursor)this.query.getSingleResult();
        return new QueryCursor(cursor, null, null);
    }

    public Optional<R> executeWithParametersSingleResult(Map<String, Object> parameters) {
        List<R> result = this.executeWithParameters(parameters);
        if (!result.isEmpty()) {
            if (result.size() > 1) {
                LoggerFactory.getLogger(this.getClass()).warn("Multiple results in list where single result expected", new Throwable());
            }
            return Optional.of(result.get(0));
        }
        return Optional.empty();
    }
}

