/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.dialogs;

import ch.elexis.core.ui.laboratory.dialogs.LabItemLabelProvider;
import ch.elexis.core.ui.laboratory.dialogs.LabItemViewerFilter;
import ch.elexis.core.ui.laboratory.dialogs.LabItemViewerSorter;
import ch.elexis.core.ui.laboratory.dialogs.Messages;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabMapping;
import ch.elexis.data.Query;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MergeLabItemDialog
extends TitleAreaDialog {
    private TableViewer destinationItems;
    private Text destinationFilterTxt;
    private LabItemViewerFilter destinationFilter;
    private TableViewer sourceItems;
    private Text sourceFilterTxt;
    private LabItemViewerFilter sourceFilter;
    private LabItemLabelProvider labelProvider = new LabItemLabelProvider(true);

    public MergeLabItemDialog(Shell parentShell, LabItem act) {
        super(parentShell);
        this.destinationFilter = new LabItemViewerFilter(this.labelProvider);
        this.sourceFilter = new LabItemViewerFilter(this.labelProvider);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.MergeLabItemDialog_title);
        this.setTitle(Messages.MergeLabItemDialog_title);
        this.setMessage(Messages.MergeLabItemDialog_pleaseMergeParam);
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)new GridData(1808));
        ret.setLayout((Layout)new GridLayout(1, false));
        Label lbl = new Label(ret, 0);
        lbl.setText(Messages.MergeLabItemDialog_labelMergeTo);
        GridData layoutData = new GridData(4, 4, true, false, 4, 1);
        layoutData.heightHint = 150;
        this.destinationFilterTxt = new Text(ret, 2048);
        this.destinationFilterTxt.setLayoutData((Object)new GridData(768));
        this.destinationFilterTxt.setMessage("Filter");
        this.destinationFilterTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MergeLabItemDialog.this.destinationFilterTxt.getText().length() > 1) {
                    MergeLabItemDialog.this.destinationFilter.setSearchText(MergeLabItemDialog.this.destinationFilterTxt.getText());
                    MergeLabItemDialog.this.destinationItems.refresh();
                } else {
                    MergeLabItemDialog.this.destinationFilter.setSearchText("");
                    MergeLabItemDialog.this.destinationItems.refresh();
                }
            }
        });
        this.destinationItems = new TableViewer(ret, 2048);
        this.destinationItems.getTable().setLayoutData((Object)layoutData);
        this.destinationItems.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.destinationItems.setLabelProvider((IBaseLabelProvider)new LabItemLabelProvider(true));
        this.destinationItems.setSorter((ViewerSorter)new LabItemViewerSorter(this.labelProvider));
        this.destinationItems.addFilter((ViewerFilter)this.destinationFilter);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.destinationItems, (int)2);
        lbl = new Label(ret, 0);
        lbl.setText(Messages.MergeLabItemDialog_labelMergeFrom);
        this.sourceFilterTxt = new Text(ret, 2048);
        this.sourceFilterTxt.setLayoutData((Object)new GridData(768));
        this.sourceFilterTxt.setMessage("Filter");
        this.sourceFilterTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MergeLabItemDialog.this.sourceFilterTxt.getText().length() > 1) {
                    MergeLabItemDialog.this.sourceFilter.setSearchText(MergeLabItemDialog.this.sourceFilterTxt.getText());
                    MergeLabItemDialog.this.sourceItems.refresh();
                } else {
                    MergeLabItemDialog.this.sourceFilter.setSearchText("");
                    MergeLabItemDialog.this.sourceItems.refresh();
                }
            }
        });
        this.sourceItems = new TableViewer(ret, 2048);
        this.sourceItems.getTable().setLayoutData((Object)layoutData);
        this.sourceItems.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sourceItems.setLabelProvider((IBaseLabelProvider)new LabItemLabelProvider(true));
        this.sourceItems.setSorter((ViewerSorter)new LabItemViewerSorter(this.labelProvider));
        this.sourceItems.addFilter((ViewerFilter)this.sourceFilter);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.sourceItems, (int)2);
        List allItems = LabItem.getLabItems();
        this.destinationItems.setInput((Object)allItems);
        this.sourceItems.setInput((Object)allItems);
        return ret;
    }

    protected void okPressed() {
        StructuredSelection selection = (StructuredSelection)this.destinationItems.getSelection();
        if (selection.isEmpty()) {
            this.setErrorMessage(Messages.MergeLabItemDialog_errorNoToLabItemSelected);
            return;
        }
        LabItem destination = (LabItem)selection.getFirstElement();
        selection = (StructuredSelection)this.sourceItems.getSelection();
        if (selection.isEmpty()) {
            this.setErrorMessage(Messages.MergeLabItemDialog_errorNoFromLabItemSelected);
            return;
        }
        LabItem source = (LabItem)selection.getFirstElement();
        if (source == destination) {
            this.setErrorMessage(Messages.MergeLabItemDialog_errorSameSelected);
            return;
        }
        boolean confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.MergeLabItemDialog_titleWarningDialog, (String)Messages.MergeLabItemDialog_messageWarningDialog);
        if (!confirm) {
            return;
        }
        destination.mergeWith(source);
        this.deleteMappings(source);
        source.delete();
        super.okPressed();
    }

    private void deleteMappings(LabItem li) {
        Query qbe = new Query(LabMapping.class);
        qbe.add("labitemid", "=", li.getId());
        List list = qbe.execute();
        for (LabMapping po : list) {
            po.delete();
        }
    }
}

