/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.dialogs;

import ch.elexis.core.ui.laboratory.controls.LabItemTreeSelectionComposite;
import ch.elexis.core.ui.laboratory.dialogs.LabItemLabelProvider;
import ch.elexis.core.ui.laboratory.preferences.Messages;
import ch.elexis.data.LabItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LabItemSelektor
extends TitleAreaDialog {
    private LabItemTreeSelectionComposite treeSelectionComposite;
    private ILabelProvider labelProvider;
    private List<LabItem> selection = Collections.emptyList();

    public LabItemSelektor(Shell parentShell) {
        super(parentShell);
        this.labelProvider = new LabelProvider(){
            private ILabelProvider itemLabelProvider = new LabItemLabelProvider(Arrays.asList(LabItemLabelProvider.ItemLabelFields.KUERZEL, LabItemLabelProvider.ItemLabelFields.NAME, LabItemLabelProvider.ItemLabelFields.REFERENCES, LabItemLabelProvider.ItemLabelFields.UNIT), false);

            public String getText(Object element) {
                if (element instanceof LabItemTreeSelectionComposite.Group) {
                    return ((LabItemTreeSelectionComposite.Group)element).toString();
                }
                if (element instanceof LabItemTreeSelectionComposite.GroupItem) {
                    return this.itemLabelProvider.getText((Object)((LabItemTreeSelectionComposite.GroupItem)element).getLabItem());
                }
                return "?";
            }
        };
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setMessage(Messages.LabGroupPrefs_pleaseSelectLabItems);
        this.setTitle(Messages.LabGroupPrefs_selectLabItems);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.treeSelectionComposite = new LabItemTreeSelectionComposite(composite, this.labelProvider, false, 0);
        this.treeSelectionComposite.setLayoutData(new GridData(768));
        return composite;
    }

    protected void okPressed() {
        List<LabItemTreeSelectionComposite.GroupItem> groupItems = this.treeSelectionComposite.getSelectedItems();
        this.selection = new ArrayList<LabItem>();
        for (LabItemTreeSelectionComposite.GroupItem groupItem : groupItems) {
            this.selection.add(groupItem.getLabItem());
        }
        super.okPressed();
    }

    public List<LabItem> getSelection() {
        return this.selection;
    }
}

