/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.actions;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.ui.laboratory.controls.LaborOrderViewerItem;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.data.LabOrder;
import ch.elexis.data.LabResult;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;

public class LaborResultOrderDeleteAction
extends Action
implements IAction {
    private List<?> selectedOrdersOrResults;
    private final Shell shell;
    private final StructuredViewer viewer;

    public LaborResultOrderDeleteAction(List<?> list, StructuredViewer viewer) {
        super(Messages.LabResultOrOrderDeleteAction_title);
        this.selectedOrdersOrResults = list;
        this.viewer = viewer;
        this.shell = viewer.getControl().getShell();
    }

    public LaborResultOrderDeleteAction(List<?> list, Shell shell) {
        super(Messages.LabResultOrOrderDeleteAction_title);
        this.selectedOrdersOrResults = list;
        this.viewer = null;
        this.shell = shell;
    }

    public void run() {
        String[] dialogButtonLabels = this.selectedOrdersOrResults.size() > 1 ? new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL} : new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
        Boolean persistedDelete = null;
        for (Object object : this.selectedOrdersOrResults) {
            LabResult result;
            LabOrder order;
            Boolean delete = null;
            if (object instanceof LabOrder) {
                order = (LabOrder)object;
                result = (LabResult)order.getLabResult();
            } else if (object instanceof LabResult) {
                result = (LabResult)object;
                order = result.getLabOrder();
            } else if (object instanceof LaborOrderViewerItem) {
                result = ((LaborOrderViewerItem)object).getLabResult();
                order = ((LaborOrderViewerItem)object).getLabOrder();
            } else {
                throw new IllegalArgumentException("Unknown list entry type of class " + object.getClass());
            }
            if (persistedDelete == null) {
                MessageDialog dialog = new MessageDialog(this.shell, "Resultat/Verordnung entfernen", null, "Soll das Resultat [" + result + "] sowie die zugeh. Verordnung wirklich entfernt werden?", 5, dialogButtonLabels, dialogButtonLabels.length);
                int open = dialog.open();
                if (dialogButtonLabels.length == 2) {
                    delete = open == 0;
                } else if (open == 0) {
                    delete = true;
                } else if (open == 1) {
                    persistedDelete = true;
                } else if (open == 2) {
                    delete = false;
                } else if (open == 3) {
                    persistedDelete = false;
                }
            }
            if (!Objects.equals(Boolean.TRUE, delete) && !Objects.equals(Boolean.TRUE, persistedDelete)) continue;
            AcquireLockBlockingUi.aquireAndRun((IPersistentObject)(result != null ? result : order), (ILockHandler)new ILockHandler(){

                public void lockFailed() {
                }

                public void lockAcquired() {
                    if (result != null) {
                        result.delete();
                    }
                    if (order != null) {
                        order.delete();
                    }
                    if (LaborResultOrderDeleteAction.this.viewer != null) {
                        LaborResultOrderDeleteAction.this.viewer.refresh();
                    }
                }
            });
            ElexisEventDispatcher.reload(LabResult.class);
        }
    }

    public boolean isEnabled() {
        return this.selectedOrdersOrResults != null && !this.selectedOrdersOrResults.isEmpty();
    }
}

