/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.helper;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IPatient;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Reference;

public class ICoverageHelper
extends AbstractHelper {
    public String getDependent(ICoverage coverage) {
        String ret = coverage.getInsuranceNumber();
        if (ret == null) {
            ret = (String)coverage.getExtInfo((Object)"Versicherungsnummer");
        }
        return ret;
    }

    public void setBin(ICoverage coverage, String bin) {
        String billingSystem = coverage.getBillingSystem().getName();
        if (billingSystem != null && !billingSystem.isEmpty()) {
            if (billingSystem.equals("UVG")) {
                coverage.setExtInfo((Object)"Unfallnummer", (Object)bin);
            } else {
                coverage.setExtInfo((Object)"Versicherungsnummer", (Object)bin);
            }
        }
    }

    public Reference getBeneficiaryReference(ICoverage fall) {
        IPatient patient = fall.getPatient();
        if (patient != null) {
            return new Reference((IIdType)new IdDt("Patient", patient.getId()));
        }
        return null;
    }

    public Reference getIssuerReference(ICoverage fall) {
        IContact kostenTr = fall.getCostBearer();
        if (kostenTr != null) {
            if (kostenTr.isOrganization()) {
                return new Reference((IIdType)new IdDt("Organization", kostenTr.getId()));
            }
            if (kostenTr.isPatient()) {
                return new Reference((IIdType)new IdDt("Patient", kostenTr.getId()));
            }
        }
        return null;
    }

    public Period getPeriod(ICoverage coverage) {
        LocalDate endDate;
        Period period = new Period();
        LocalDate startDate = coverage.getDateFrom();
        if (startDate != null) {
            period.setStart(this.getDate(startDate.atStartOfDay()));
        }
        if ((endDate = coverage.getDateTo()) != null) {
            period.setEnd(this.getDate(endDate.atStartOfDay()));
        }
        return period;
    }

    public void setPeriod(ICoverage coverage, Period period) {
        if (period.getStart() != null) {
            coverage.setDateFrom(this.getLocalDateTime(period.getStart()).toLocalDate());
        }
    }

    public String getFallText(ICoverage coverage) {
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        String grund = coverage.getReason();
        String bezeichnung = coverage.getDescription();
        LocalDate dateFrom = coverage.getDateFrom();
        LocalDate dateTo = coverage.getDateTo();
        String billingSystem = coverage.getBillingSystem().getName();
        if (dateFrom == null) {
            dateFrom = LocalDate.of(1970, 1, 1);
        }
        StringBuilder ret = new StringBuilder();
        if (dateTo != null) {
            ret.append("-GESCHLOSSEN-");
        }
        ret.append(billingSystem).append(": ").append(grund).append(" - ");
        ret.append(bezeichnung).append("(");
        String ed = dateTo == null ? "offen" : dateTo.format(dateFormat);
        ret.append(dateFrom.format(dateFormat)).append("-").append(ed).append(")");
        return ret.toString();
    }

    public Optional<CodeableConcept> getType(ICoverage coverage) {
        CodeableConcept ret = new CodeableConcept();
        String billingSystem = coverage.getBillingSystem().getName();
        if (billingSystem != null) {
            Coding coding = new Coding();
            coding.setSystem(CodingSystem.ELEXIS_COVERAGE_TYPE.getSystem());
            coding.setCode(billingSystem);
            ret.addCoding(coding);
        }
        return Optional.of(ret);
    }

    public Optional<String> getType(Coverage fhirObject) {
        CodeableConcept fhirType = fhirObject.getType();
        for (Coding coding : fhirType.getCoding()) {
            if (!coding.getSystem().equals(CodingSystem.ELEXIS_COVERAGE_TYPE.getSystem())) continue;
            return Optional.ofNullable(coding.getCode());
        }
        return Optional.empty();
    }
}

