/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.helper;

import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import ch.elexis.core.model.IAppointment;
import org.hl7.fhir.r4.model.Appointment;
import org.hl7.fhir.r4.model.Slot;

public class IAppointmentHelper
extends AbstractHelper {
    public Slot.SlotStatus getSlotStatus(IAppointment localObject) {
        String type;
        switch (type = localObject.getType()) {
            case "frei": {
                return Slot.SlotStatus.FREE;
            }
            case "gesperrt": {
                return Slot.SlotStatus.BUSYUNAVAILABLE;
            }
        }
        return Slot.SlotStatus.BUSY;
    }

    public String getDescription(IAppointment localObject) {
        String grund = localObject.getReason();
        if (grund == null || grund.length() < 1) {
            return localObject.getType();
        }
        return grund;
    }

    public void mapApplyAppointmentStatus(Appointment target, IAppointment source) {
        String appointmentState;
        switch (appointmentState = source.getState()) {
            case "eingetroffen": {
                target.setStatus(Appointment.AppointmentStatus.ARRIVED);
                return;
            }
            case "erledigt": {
                target.setStatus(Appointment.AppointmentStatus.FULFILLED);
                return;
            }
            case "abgesagt": {
                target.setStatus(Appointment.AppointmentStatus.CANCELLED);
                return;
            }
            case "nicht erschienen": {
                target.setStatus(Appointment.AppointmentStatus.NOSHOW);
                return;
            }
        }
        target.setStatus(Appointment.AppointmentStatus.BOOKED);
    }

    public void mapApplyAppointmentStatus(IAppointment target, Appointment source) {
        Appointment.AppointmentStatus status = source.getStatus();
        switch (status) {
            case FULFILLED: {
                target.setState("erledigt");
                return;
            }
            case ARRIVED: {
                target.setState("eingetroffen");
                return;
            }
            case CANCELLED: {
                target.setState("abgesagt");
                return;
            }
            case NOSHOW: {
                target.setState("nicht erschienen");
                return;
            }
        }
        target.setState("-");
    }
}

